/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import robbie.util.JndiUtil;

public class DbConnectionUtil {
    public static final String DRIVER_CLASS_NAME_KEY = "driver.class.name";
    public static final String PASSWORD_KEY = "password";
    public static final String SERVER_URL_KEY = "server.url";
    public static final String USERNAME_KEY = "username";
    static /* synthetic */ Class class$javax$sql$DataSource;

    private DbConnectionUtil() {
    }

    public static Connection getConnection(Properties env) throws ClassNotFoundException, SQLException {
        String driverName = (String)env.get(DRIVER_CLASS_NAME_KEY);
        Class.forName(driverName);
        String url = (String)env.get(SERVER_URL_KEY);
        String username = (String)env.get(USERNAME_KEY);
        String password = (String)env.get(PASSWORD_KEY);
        return DriverManager.getConnection(url, username, password);
    }

    public static Connection getConnection(String driverName, String url) throws ClassNotFoundException, SQLException {
        Class.forName(driverName);
        return DriverManager.getConnection(url);
    }

    public static Connection getConnection(String driverName, String url, Properties info) throws ClassNotFoundException, SQLException {
        Class.forName(driverName);
        return DriverManager.getConnection(url, info);
    }

    public static Connection getConnectionByDataSource(String dsName) throws NamingException, SQLException {
        DataSource ds = DbConnectionUtil.getDataSource(dsName);
        return ds.getConnection();
    }

    public static DataSource getDataSource(String dsName) throws NamingException {
        return (DataSource)JndiUtil.getJNDIValue(dsName, class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = DbConnectionUtil.class$("javax.sql.DataSource")) : class$javax$sql$DataSource);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

