/*
 * Decompiled with CFR 0.152.
 */
package robbie.dao;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import robbie.dao.DaoSysException;
import robbie.util.CollectionsUtil;

public class DaoUtil {
    private static final Log LOGGER = LogFactory.getLog((Class)(class$robbie$dao$DaoUtil == null ? (class$robbie$dao$DaoUtil = DaoUtil.class$("robbie.dao.DaoUtil")) : class$robbie$dao$DaoUtil));
    static /* synthetic */ Class class$robbie$dao$DaoUtil;
    static /* synthetic */ Class class$java$lang$Integer;

    private DaoUtil() {
    }

    public static List resultSetToMapList(ResultSet rs) throws SQLException {
        List list = CollectionsUtil.createList();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            int name_i = i + 1;
            columnNames[i] = rsMetaData.getColumnName(name_i);
        }
        while (rs.next()) {
            Map columnMap = CollectionsUtil.createMap();
            for (int i = 0; i < columnNames.length; ++i) {
                int object_i = i + 1;
                columnMap.put(columnNames[i], rs.getObject(object_i));
            }
            list.add(columnMap);
        }
        if (list.size() == 0) {
            list = null;
        }
        return list;
    }

    public static Object[][] resultSetToArray(ResultSet rs) throws SQLException {
        List list = CollectionsUtil.createList();
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int columnCount = rsMetaData.getColumnCount();
        Object[] columnNames = new Object[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            int name_i = i + 1;
            columnNames[i] = rsMetaData.getColumnName(name_i);
        }
        list.add(columnNames);
        while (rs.next()) {
            Object[] columnValue = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                int object_i = i + 1;
                columnValue[i] = rs.getObject(object_i);
            }
            list.add(columnValue);
        }
        if (list.size() <= 1) {
            return null;
        }
        Object[] before = list.toArray();
        Object[][] after = new Object[before.length][];
        for (int i = 0; i < before.length; ++i) {
            after[i] = (Object[])before[i];
        }
        return after;
    }

    public static final List resultSetToBeansList(Class beanClass, ResultSet rs) throws Exception {
        List beanList = CollectionsUtil.createList();
        if (rs != null) {
            ResultSetMetaData rsMetaData = rs.getMetaData();
            int columnCount = rsMetaData.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = rsMetaData.getColumnName(i + 1);
            }
            BeanInfo info = Introspector.getBeanInfo(beanClass);
            PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
            if (descriptors == null) {
                return beanList;
            }
            Map descriptorMap = CollectionsUtil.createMap();
            for (int i = 0; i < descriptors.length; ++i) {
                descriptorMap.put(descriptors[i].getName().toLowerCase(), descriptors[i]);
            }
            while (rs.next()) {
                Object bean = beanClass.newInstance();
                for (int i = 0; i < columnNames.length; ++i) {
                    String columnName = DaoUtil.columnNameToPropertyName(columnNames[i]).toLowerCase();
                    if (!descriptorMap.containsKey(columnName)) continue;
                    PropertyDescriptor descriptor = (PropertyDescriptor)descriptorMap.get(columnName);
                    Object arg = DaoUtil.convertObjectIfNeeded(descriptor.getPropertyType(), descriptor.getName(), columnNames[i], rs.getObject(i + 1));
                    Object[] args = new Object[]{arg};
                    descriptor.getWriteMethod().invoke(bean, args);
                }
                beanList.add(bean);
            }
        }
        return beanList;
    }

    public static final Map beansToMap(Object beans) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> beansClass = beans.getClass();
        BeanInfo info = Introspector.getBeanInfo(beansClass);
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        if (descriptors == null) {
            return null;
        }
        Map map = CollectionsUtil.createMap();
        for (int i = 0; i < descriptors.length; ++i) {
            PropertyDescriptor descriptor = descriptors[i];
            Object[] args = new Object[]{};
            map.put(descriptors[i].getName(), descriptor.getReadMethod().invoke(beans, args));
        }
        return map;
    }

    private static String columnNameToPropertyName(String columnName) {
        return columnName.replaceAll("[_]", "");
    }

    private static final Object convertObjectIfNeeded(Class objClass, String propName, String columnName, Object obj) {
        if (LOGGER.isDebugEnabled()) {
            String className = null;
            className = obj != null ? obj.getClass().getName() : "null";
            LOGGER.debug((Object)("Column[" + columnName + ":" + className + "] -> " + "Property[" + propName + ":" + objClass.getName() + "] "));
        }
        if (DaoUtil.isPrimitiveType(objClass)) {
            if (Integer.TYPE.equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Integer(((Number)obj).intValue());
                }
                if (obj == null) {
                    return new Integer(0);
                }
                throw new DaoSysException("Object is not instance of Integer or Number. obj=" + obj);
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Long(((Number)obj).longValue());
                }
                if (obj == null) {
                    return new Long(0L);
                }
                throw new DaoSysException("Object is not instance of Long or Number. obj=" + obj);
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Short(((Number)obj).shortValue());
                }
                if (obj == null) {
                    return new Short(0);
                }
                throw new DaoSysException("Object is not instance of Short or Number. obj=" + obj);
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Float(((Number)obj).floatValue());
                }
                if (obj == null) {
                    return new Float(0.0f);
                }
                throw new DaoSysException("Object is not instance of Float or Number. obj=" + obj);
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                if (obj instanceof Number) {
                    return new Double(((Number)obj).doubleValue());
                }
                if (obj == null) {
                    return new Double(0.0);
                }
                throw new DaoSysException("Object is not instance of Double or Number. obj=" + obj);
            }
            if (Boolean.TYPE.equals(objClass)) {
                if (obj instanceof Boolean) {
                    return obj;
                }
                if (obj == null) {
                    return new Boolean(false);
                }
                throw new DaoSysException("Object is not instance of Boolean. obj=" + obj);
            }
            if (Byte.TYPE.equals(objClass)) {
                if (obj instanceof Byte) {
                    return obj;
                }
                if (obj == null) {
                    return new Byte(0);
                }
                throw new DaoSysException("Object is not instance of Byte. obj=" + obj);
            }
            if (Character.TYPE.equals(objClass)) {
                if (obj instanceof Character) {
                    return obj;
                }
                if (obj == null) {
                    return new Character('\u0000');
                }
                throw new DaoSysException("Object is not instance of Character. obj=" + obj);
            }
        } else if (obj instanceof Number) {
            if ((class$java$lang$Integer == null ? (class$java$lang$Integer = DaoUtil.class$("java.lang.Integer")) : class$java$lang$Integer).equals(objClass)) {
                if (obj instanceof Integer) {
                    return obj;
                }
                return new Integer(((Number)obj).intValue());
            }
            if (Long.TYPE.equals(objClass)) {
                if (obj instanceof Long) {
                    return obj;
                }
                return new Long(((Number)obj).longValue());
            }
            if (Short.TYPE.equals(objClass)) {
                if (obj instanceof Short) {
                    return obj;
                }
                return new Short(((Number)obj).shortValue());
            }
            if (Float.TYPE.equals(objClass)) {
                if (obj instanceof Float) {
                    return obj;
                }
                return new Float(((Number)obj).floatValue());
            }
            if (Double.TYPE.equals(objClass)) {
                if (obj instanceof Double) {
                    return obj;
                }
                return new Double(((Number)obj).doubleValue());
            }
        }
        return obj;
    }

    private static boolean isPrimitiveType(Class objClass) {
        if (Integer.TYPE.equals(objClass)) {
            return true;
        }
        if (Long.TYPE.equals(objClass)) {
            return true;
        }
        if (Float.TYPE.equals(objClass)) {
            return true;
        }
        if (Double.TYPE.equals(objClass)) {
            return true;
        }
        if (Boolean.TYPE.equals(objClass)) {
            return true;
        }
        if (Short.TYPE.equals(objClass)) {
            return true;
        }
        if (Byte.TYPE.equals(objClass)) {
            return true;
        }
        return Character.TYPE.equals(objClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

