<?php
/* ========================================================================
 - [create/browse.php]
 - 内容：テーブルの作成
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] PDO1.0以降に対応
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * テーブル名
     * @var string
     */
    private $name = '';

    /**
     * フィールド数
     * @var integer
     */
    private $field_num = '';

    /**
     * テーブルが存在するか
     * @var integer
     */
    private $exist = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'create/create.tpl';
        $this->addCss('common.css');

        $this->name = empty($_REQUEST['name'])?'':$_REQUEST['name'];
        $this->field_num = empty($_REQUEST['field_num'])?'':$_REQUEST['field_num'];
        $this->set_exist();

        if (!empty($_REQUEST['send_query'])){
            $this->dbinfo->setQuery($this->get_query());
            header("Location: ".$_SERVER['PHP_SELF']."?m=query&do_query=".$this->dbinfo->getAutoQuery());
            exit();
        }

        $this->Assign('name', $this->name);
        $this->Assign('field_num', $this->field_num);

        $this->set_field();
    }

    /**
     * テーブルが存在するか
     *
     * @access private
     * @return void
     **/
    private function set_exist()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT count(name) as ct FROM sqlite_master WHERE type='table' AND name='".$this->name."'");
        $stmt->execute(); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        $this->exist = $result['ct'];
    }

    /**
     * テーブルリストの設定
     *
     * @access private
     * @return void
     **/
    private function set_field()
    {
        $fields = $this->get_fields();
        $list = array();

        foreach ($fields as $row=>$field){
            $list[] = array(
                    'row'=>     $row,
                    'field'=>   $field['field'],
                    'type'=>    $this->get_type($field['type']),
                    'length'=>  $field['length'],
                    'notnull'=> $this->get_notnull($field['notnull']),
                    'default'=> $field['default'],
                    'key'=>     $this->get_key($field['key'])
                    
                );
        }

        $this->Assign('fields', $list);
    }

    /**
     * SQLを解析しキー情報を取得する
     *
     * @access public
     * @return キー情報の格納配列
     **/
    private function get_constraint()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT sql FROM sqlite_master WHERE name='".$this->name."'");
        $stmt->execute(); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        $sql = preg_replace("/\((.+)\)/is",",\\1,",$result['sql']);
        $sql = preg_replace('/"/i','',$sql);
        $sqls = explode(',', $sql);

        $keys = array();
        $cmd = "";
        foreach ($sqls as $sql){
            if (preg_match("/PRIMARY/i", $sql)){
                $sql = trim($sql);
                $cmd .= '/*';
                $cmd .= preg_replace("/\((.+)\)|(^\S+)/is","*/\$keys['\\1\\2']='PRIMARY';/*",$sql);
                $cmd .= '*/';
            } else if (preg_match("/UNIQUE/i", $sql)){
                $sql = trim($sql);
                $cmd .= '/*';
                $cmd .= preg_replace("/\((.+)\)|(^\S+)/is","*/\$keys['\\1\\2']='UNIQUE';/*",$sql);
                $cmd .= '*/';
            }
        }
        @eval($cmd);
        
        return ($keys);
    }

    /**
     * テーブルリストの設定
     *
     * @access private
     * @return void
     **/
    private function get_fields()
    {
        $start = 0;

        /* 既存のフィールド情報 */
        if ($this->exist){
            $keys = $this->get_constraint();
            $stmt = $this->objdb->prepare("PRAGMA table_info(".$this->name.")"); 
            $stmt->execute(); 

            $fields = array();
            $cols = array();
            while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $type = preg_replace("/\(.+\)/i","",$cols['type']);
                $length = preg_replace("/[^0-9\.]+/i","",$cols['type']);
                $key = empty($keys[$cols['name']])?'':$keys[$cols['name']];

                $fields[] = array(
                        'field'=>   $cols['name'],
                        'type'=>    $type,
                        'length'=>  $length,
                        'notnull'=> (empty($cols['notnull']) ? '': 'NOT NULL'),
                        'default'=> $cols['dflt_value'],
                        'key'=>     $key
                    );
                $start++;
            }
        } // if ($this->exist)

        /* 新規のフィールド情報 */
        for ($row=0; $row<$this->field_num; $row++){
            $fields[$row + $start]['field']  = empty($_POST['field'][$row]) ? "":$_POST['field'][$row];
            $fields[$row + $start]['type']   = empty($_POST['type'][$row]) ? "":$_POST['type'][$row];
            $fields[$row + $start]['length'] = empty($_POST['length'][$row]) ? "":$_POST['length'][$row];
            $fields[$row + $start]['notnull']= empty($_POST['notnull'][$row]) ? "":$_POST['notnull'][$row];
            $fields[$row + $start]['default']= empty($_POST['default'][$row]) ? "":$_POST['default'][$row];
            $fields[$row + $start]['key']    = empty($_POST['key'][$row]) ? "":$_POST['key'][$row];
        }
        return ($fields);
    }

    /**
     * SELECTオプション用型名の取得
     *
     * @access private
     * @return array SELECTオプション用型名
     **/
    private function get_type($selected)
    {
        $types = array(
            'TINYINT'=>   'TINYINT',
            'SMALLINT'=>  'SMALLINT',
            'MEDIUMINT'=> 'MEDIUMINT',
            'INT'=>       'INT',    
            'INTEGER'=>   'INTEGER',
            'BIGINT'=>    'BIGINT', 
            'REAL'=>      'REAL',
            'DOUBLE'=>    'DOUBLE',
            'FLOAT'=>     'FLOAT', 
            'DECIMAL'=>   'DECIMAL',
            'NUMERIC'=>   'NUMERIC',
            'CHAR'=>      'CHAR',
            'VARCHAR'=>   'VARCHAR',
            'DATE'=>      'DATE',
            'TIME'=>      'TIME',
            'TIMESTAMP'=> 'TIMESTAMP',
            'DATETIME'=>  'DATETIME',
            'TINYBLOB'=>  'TINYBLOB',
            'BLOB'=>      'BLOB',
            'MEDIUMBLOB'=>'MEDIUMBLOB',
            'LONGBLOB'=>  'LONGBLOB',
            'TINYTEXT'=>  'TINYTEXT',
            'TEXT'=>      'TEXT',
            'MEDIUMTEXT'=>'MEDIUMTEXT',
            'LONGTEXT'=>  'LONGTEXT'
        );
        $selected = strtoupper($selected);
        return $this->getSelectList($types,$selected);
    }

    /**
     * SELECTオプション用NOT NULLの取得
     *
     * @access private
     * @return array SELECTオプション用NOT NULL
     **/
    private function get_notnull($selected)
    {
        $notnulls = array(
            ''=>'',
            'NOT NULL'=>'NOT NULL'
        );
        $selected = strtoupper($selected);
        return $this->getSelectList($notnulls,$selected);
    }

    /**
     * SELECTオプション用キーの取得
     *
     * @access private
     * @return array SELECTオプション用キー
     **/
    private function get_key($selected)
    {
        $keys = array(
            ''=>'',
            'PRIMARY'=>'PRIMARY',
            'UNIQUE'=>'UNIQUE'
        );
        $selected = strtoupper($selected);
        return $this->getSelectList($keys,$selected);
    }

    /**
     * 生成したクエリの取得
     *
     * @access private
     * @return string
     **/
    private function get_query()
    {
        $keyset = array(
            "PRIMARY"=> "PRIMARY KEY",
            "UNIQUE"=> "UNIQUE"
        );
        $keys = array();
        $fields = array();

        $column = "";
        foreach ($_POST['fields'] as $value){
            $column .= $value['field'];
            $column .= ' '.$value['type'];
            $column .= empty($value['length']) ? '': '('.$value['length'].')';
            $column .= empty($value['notnull']) ? '': ' '.$value['notnull'];
            $column .= empty($value['default']) ? '': ' DEFAULT '.$value['default'];
            $column .= ",\n    ";

            if (!empty($value['key'])){
                $keys[] = $keyset[$value['key']]." (".$value['field'].")";
            }
        
            $default = empty($value['default']) ? '1': $value['default'];
            if (empty($value['notnull'])) {
                $fields[$value['field']] = 'NULL as '.$value['field'];
            } else {
                $fields[$value['field']] = "'".$default."' as ".$value['field'];
            }
        }

        /* キーの設定 */    
        if (count($keys) != 0){
            $column .= implode(",\n    ", $keys);
        } else {
            $column = substr($column,0,-6);
        }
    
        $query = "";
        if ($this->exist){
            return $this->get_alter($column);
        } else {
            $query = "CREATE TABLE ".$this->name." (\n    ";
            $query .= $column;
            $query .= "\n)";
        }
        
        return $query;
    }

    /**
     * テーブル情報の更新
     *
     * @access private
     * @return string
     **/
    private function get_alter($column)
    {
        /* 既存のフィールド情報 */
        $stmt = $this->objdb->prepare("PRAGMA table_info(".$this->name.")"); 
        $stmt->execute(); 

        $fields = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) { 
            $fields[] = $cols['name'];
        }
        $field = implode(",", $fields);

        $alter = 
            "CREATE TEMPORARY TABLE ".$this->name."_alter (\n".
            $column."\n".
            ");\n".
            "INSERT INTO ".$this->name."_alter SELECT ".$field." FROM ".$this->name.";\n".
            "DROP TABLE ".$this->name.";\n".
            "CREATE TABLE ".$this->name." (\n".
            $column."\n".
            ");\n".
            "INSERT INTO ".$this->name." SELECT * FROM ".$this->name."_alter;\n".
            "DROP TABLE ".$this->name."_alter;\n";
        return ($alter);
    }

} // webapp
?>
