<?php
/* ========================================================================
 - [rsl_webapp.php]
 - 内容：WebApplicationクラス
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2004 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/04] 作成
 - ======================================================================== */

require_once LIB_DIR.'rsl_db.php';
require_once LIB_DIR.'rsl_htmltpl.php';
require_once WEBAPP_LIB_DIR.'rsl_db_info.php';

/**
 * WebApplicationクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RSL_webapp
 * @access public
 * @version 1.0
 */
abstract class RSL_webapp extends RSL_htmltpl
{
    /**
     * DB接続オジェクト
     * @var object
     */
    protected $objdb = null;

    /**
     * トランザクションフラグ
     * @var boolean
     */
    protected $transaction = false;

    /**
     * DB情報オジェクト
     * @var object
     */
    protected $dbinfo = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    abstract public function execute();

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
        $this->dbinfo = RSL_db_info::Instance();
        $this->objdb = RSL_db::Instance($this->dbinfo->getDbFile());

        $this->baseAssign('db_name',$this->dbinfo->getDbName());
        $this->baseAssign('tables',$this->getMasterList('table'));
        $this->baseAssign('views',$this->getMasterList('view'));
        $this->baseAssign('triggers',$this->getMasterList('trigger'));
        $this->baseAssign('access',RSL_ACCESS);
        $this->baseAssign('help_url',RSL_HELP);
        $this->baseAssign('version',RSL_VERSION);
    }

    /**
     * 表示処理
     *
     * @access public
     * @return void
     **/
    public function display()
    {
        try {
            $this->execute();
        } catch (PDOException $exception){
            if ($this->transaction){
                $this->objdb->rollBack();
            }

            $trace = $exception->getTrace();
            $sql = $this->dbinfo->getQuery();
            $error = array(
                    'error'=> $exception->getMessage(),
                    'sql'  => $sql,
                    'trace'=> print_r($trace,true)
                );

            $this->Assign('debug',DEBUG_ENV);
            $this->Assign('error',$error);
            $this->template_file = 'error.tpl';
        }
        $this->mixOutput();
    }

    /**
     * マスターリストの取得
     *
     * @access public
     * @return array
     * @return void
     **/
    public function getMasterList($type='table')
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT name FROM sqlite_master WHERE type='".$type."' ORDER BY name"); 
        $stmt->execute(); 

        $list = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) { 
            $list[] = array('name'=>$cols['name']);
        }
        return $list;
    }
}
// RSL_webappの終了
?>
