<?php
/* ========================================================================
 - [query/table.php]
 - 内容：TableQuery実行
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rsl_pager.php';
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * テーブル名
     * @var string
     */
    private $name = '';

    /**
     * rowid
     * @var integer
     */
    private $rowid = 0;

    /**
     * fields
     * @var array
     */
    private $fields = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'query/table.tpl';
        $this->addCss('common.css');

        $this->name = empty($_REQUEST['name'])?'':$_REQUEST['name'];
        $this->Assign('name', $this->name);

        $this->rowid = empty($_REQUEST['rowid'])?'':$_REQUEST['rowid'];
        $this->Assign('rowid', $this->rowid);

        $this->fields = empty($_REQUEST['fields'])?array():$_REQUEST['fields'];

        if (!empty($_REQUEST['send_query'])){
            $this->dbinfo->setQuery($this->get_query());
            $this->dbinfo->setTableName($this->name);
            header("Location: ".$_SERVER['PHP_SELF']."?m=query&do_query=".$this->dbinfo->getAutoQuery());
            exit();
        }

        if (!empty($_REQUEST['send_delete'])){
            $this->dbinfo->setQuery($this->get_delete());
            $this->dbinfo->setTableName($this->name);
            header("Location: ".$_SERVER['PHP_SELF']."?m=query&do_query=0");
            exit();
        }

        $this->set_field();
        $this->set_function();
    }

    /**
     * フィールド定義の取得
     *
     * @access private
     * @return array
     **/
    private function get_fields()
    {
        /* フィールド情報 */
        $stmt = $this->objdb->prepare("PRAGMA table_info(".$this->name.")"); 
        $stmt->execute(); 

        $fields = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO_FETCH_ASSOC)) {
            $nullset = empty($cols['pk']) ? false : true;
            $fields[] = array(
                    'field'=>  $cols['name'],
                    'type'=>   $cols['type'],
                    'notnull'=>(empty($cols['notnull']) ? true : $nullset)
                );
        }

        return ($fields);
    }

    /**
     * フィールドの各値を取得
     *
     * @access private
     * @return array
     **/
    private function get_values()
    {
        /* 既存のフィールド情報 */
        $stmt = $this->objdb->prepare("SELECT * FROM ".$this->name." WHERE rowid='".$this->rowid."'");
        $stmt->execute(); 

        $fields = array();
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        return $result;
    }

    /**
     * フィールド定義の設定
     *
     * @access private
     * @return void
     **/
    private function set_field()
    {
        $fields = $this->get_fields();
        $values = $this->get_values();

        $list = array();
        foreach ($fields as $row=>$field){
            $value = empty($values[$field['field']])?"":$values[$field['field']];
            $value = mb_convert_encoding($value, 'UTF-8', $this->dbinfo->getEncode());
            $list[] = array(
                    'row'=>     $row,
                    'field'=>   $field['field'],
                    'type'=>    strtoupper($field['type']),
                    'notnull'=> strtoupper($field['notnull']),
                    'value'=>   $value
                );
        }
        $this->Assign('fields', $list);
    }

    /**
     * ファンクションリストの設定
     *
     * @access private
     * @return void
     **/
    private function set_function()
    {
        $functions = array(
            ''=>'',
            'abs'=>'abs',
            'random'=>'random',
            'round'=>'round',
            'length'=>'length',
            'lower'=>'lower',
            'upper'=>'upper',
            'typeof'=>'typeof',
            'last_insert_rowid'=>'last_insert_rowid',
            'sqlite_version'=>'sqlite_version'
        );
        $selected = '';
        $this->Assign('functions', $this->getSelectList($functions,$selected));
    }


    /**
     * 生成したクエリの取得
     *
     * @access private
     * @return string
     **/
    private function get_query()
    {
        /* フィールド情報 */
        $stmt = $this->objdb->prepare("PRAGMA table_info(".$this->name.")"); 
        $stmt->execute(); 

        $set = "";
        $fields = "";
        $values = "";
        $cols = array();
        while ($cols = $stmt->fetch(PDO_FETCH_ASSOC)) {
            $null = empty($this->fields[$cols['name']]['null']) ? "''":'NULL';
            $value = empty($this->fields[$cols['name']]['value']) ? $null: "'".$this->fields[$cols['name']]['value']."'";
            $value = empty($this->fields[$cols['name']]['function']) ? $value:$this->fields[$cols['name']]['function'].'('.$value.')';
            
            $set    .= '    '.$cols['name']."=".$value.",\n";
            $fields .= $cols['name'].",\n";
            $values .= $value.",\n";
        }

        $set = substr($set,0,-2);
        $fields = substr($fields,0,-2);
        $values = substr($values,0,-2);

        $query = "";
        if (!empty($this->rowid)){
            $query = "UPDATE ".$this->name." SET \n".
                     $set."\n".
                     " WHERE \n".
                     "    rowid=".$this->rowid.";";
        } else {
            $query = "INSERT INTO ".$this->name."( \n".
                     $fields.
                     "\n)VALUES( \n".
                     $values.
                     "\n);";
        }
        
        return $query;
    }

    /**
     * DELETEクエリの取得
     *
     * @access private
     * @return string
     **/
    private function get_delete()
    {
        return "DELETE FROM ".$this->name." WHERE rowid=".$this->rowid.";";
    }
} // webapp
?>
