<?php
/* ========================================================================
 - [database/set_dump.php]
 - 内容：データベースのダンプの設定
 - 作成：高橋 裕志郎 
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/21] テーブル選択機能追加
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0.05.1.21
 */
class webapp extends RSL_webapp
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'database/set_dump.tpl';
        $this->addCss('common.css');
        $this->addJavas('common.js');

        $this->Assign('dbname',$this->dbinfo->getDbName());

        $this->Assign('tables',$this->getMasterList('table'));
        $this->Assign('views',$this->getMasterList('view'));
        $this->Assign('triggers',$this->getMasterList('trigger'));

        $selected = empty($_REQUEST['selected'])?'':' selected';
        $this->Assign('selected',$selected);
    }
} // webapp
?>
