<?php
/* ========================================================================
 - [create/view.php]
 - 内容：ビューの作成
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * ビュー名
     * @var string
     */
    private $name = '';

    /**
     * ビューが存在するか
     * @var integer
     */
    private $exist = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'create/view.tpl';
        $this->addCss('common.css');

        $this->name = empty($_REQUEST['name'])?'':$_REQUEST['name'];
        $this->Assign('name', $this->name);

        $this->set_exist();
        if (!empty($_REQUEST['send_query'])){
            $this->dbinfo->setQuery($this->get_query());
            header("Location: ".$_SERVER['PHP_SELF']."?m=query&do_query=".$this->dbinfo->getAutoQuery());
            exit();
        }

        $this->set_view();
    }

    /**
     * ビューが存在するか
     *
     * @access private
     * @return void
     **/
    private function set_exist()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT count(name) FROM sqlite_master WHERE type='view' AND name='".$this->name."'");
        $stmt->execute(); 
        $result = $stmt->fetchSingle();

        $this->exist = $result;
    }

    /**
     * ビューの詳細を設定
     *
     * @access private
     * @return void
     **/
    private function set_view()
    {
        $views = array(
                'name'=> '',
                'select'=> ''
            );

        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT sql FROM sqlite_master WHERE name='".$this->name."'"); 
        $stmt->execute(); 
        $result = $stmt->fetchSingle();

        $cmd = $result;
        $cmd = preg_replace( "/VIEW/i", "*/\$views['name']=trim(\"", $cmd, 1);
        $cmd = preg_replace( "/\bAS\b/i", "\");\$views['select']=trim(\"", $cmd, 1);
        $cmd = "/*".$cmd."\");";

        @eval($cmd);

        $this->Assign('name', $views['name']);
        $this->Assign('select', $views['select']);
    }

    /**
     * 生成したクエリの取得
     *
     * @access private
     * @return string
     **/
    private function get_query()
    {
        $name   = trim($_POST['name']);
        $select = trim($_POST['select']);

        $query = "";
        if ($this->exist){
            $query = "DROP VIEW ".$this->name.";\n";
        }

        $query .=
            "CREATE VIEW \n".
            "    ".$this->name." \n".
            "AS \n".
            "    ".$select.";";

        return $query;
    }
} // webapp
?>
