<?php
/* ========================================================================
 - [rsl_db.php]
 - 内容：データベース接続
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2003-2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/21] RSL_db::parseSql() EXPLAINに対応
 -      [2005/01/08] PDO用に大幅修正（下位互換なし）
 -      [2004/02/20] headerの出力エラーを解消
 -      [2003/12/18] version 0.1
 -      [2003/12/10] 作成
 - ======================================================================== */

/**
 * データベースクラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RSL_db
 * @access public
 * @version 2.0.05.1.21
 */
class RSL_db
{
    /**
     * DB接続オブジェクト
     * @var object
     */
    private $dbh;

    /**
     * インスタンス生成　現在の接続を返す
     *
     * @access public
     * @return object
     */
    public function &Instance($dbfile)
    {
        static $Singleton;
        
        if ($Singleton == null) {
            $Singleton = new RSL_db($dbfile);
        }
        return $Singleton->getDbHandle();
    }

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct($dbfile)
    {
        /* PDO データベースハンドルの生成 */
        $this->dbh = new PDO('sqlite:'.$dbfile,'', '');

        /* エラーモードの設定（例外処理を有効） */
        $this->dbh->setAttribute(PDO_ATTR_ERRMODE, PDO_ERRMODE_EXCEPTION);
    }

    /**
     * メンバ変数DB接続ハンドルの吐き出し
     *
     * @access public
     * @return object DB接続ハンドル
     */
    public function &getDbHandle()
    {
        return $this->dbh;
    }

    /**
     * SELECT句のSQL文を解析する
     *
     * @access public
     * @param string $query クエリ文字列
     * @return array
     */
    public function parseSql($sql)
    {
        $parse_sql = array();
        $sql = preg_replace( "/;/i", "", $sql, 1);
        $sql = preg_replace( "/EXPLAIN/i", "\$parse_sql['explain']=1;", $sql, 1);
        $sql = preg_replace( "/SELECT/i", "\$parse_sql['field']=\"", $sql, 1);
        $sql = preg_replace( "/FROM/i", "\";\$parse_sql['table']=\"", $sql, 1);
        $sql = preg_replace( "/WHERE/i", "\";\$parse_sql['where']=\"", $sql, 1);
        $sql = preg_replace( "/ORDER BY/i", "\";\$parse_sql['order']=\"", $sql, 1);
        $sql = preg_replace( "/GROUP BY/i", "\";\$parse_sql['group']=\"", $sql, 1);
        $sql = preg_replace( "/LIMIT/i", "\";\$parse_sql['limit']=\"", $sql, 1);
        $sql = preg_replace( "/OFFSET/i", "\";\$parse_sql['offset']=\"", $sql, 1);
        $sql = preg_replace( "/PRAGMA/i", "\$parse_sql['pragma']=\"", $sql, 1);
        $sql .= "\";";

        @eval($sql);
        
        return $parse_sql;
    }

    /**
     * 操作系のクエリ内容か判定
     *
     * @access public
     * @param string $query クエリ文字列
     * @return boolean
     */
    public function isManip($query)
    {
        $manips = 'CREATE|DROP|INSERT|UPDATE|DELETE|'.
                  'ROLLBACK|COPY|VACUUM|REPLACE|'.
                  'ATTACH|DETACH|CONFLICT';
        if (preg_match('/'.$manips.'/is', $query)) {
            return true;
        }
        return false;
    }

    /**
     * SQLite用にクエリを解析し配列を返す
     *
     * @access public
     * @param string $query クエリ文字列
     * @return array 解析結果の配列
     */
    public function explodeQuery($query)
    {
        $manips = 'CREATE|DROP|INSERT|UPDATE|DELETE|'.
                  'ROLLBACK|COPY|VACUUM|REPLACE|'.
                  'ATTACH|DETACH|CONFLICT';
        $query = preg_replace("/\-\-.+\n/i", '', $query);
        $query = preg_replace("/\/\*.+\*\//is", '', $query);
        $query = preg_replace('/\\\"/i', '%dqt%', $query);
        $query = preg_replace_callback('/".+"/is','remove_semicolon',$query);

        $querys = explode(';', $query);
        $is_trigger = false;
        $result = array();
        $count = count($querys);
    
        for ($row=0; $row<$count; $row++){
            if ($is_trigger){       // トリガークエリ
                if (preg_match('/END/i', $querys[$row])){
                    $trigger .= $querys[$row].';';
                    $is_trigger = false;
                    $trigger = preg_replace('/(%dqt%)/i', '\"', $trigger);
                    $result[] = preg_replace('/%semi%/i', ';', $trigger);
                } else {
                    $trigger .= $querys[$row].';';
                }
            } else {                // 通常のクエリ
                if (preg_match('/CREATE TRIGGER/i', $querys[$row])){
                    $is_trigger = true;
                    $trigger = $querys[$row].';';
                } else if (!preg_match('/BEGIN|END|COMMIT/i', $querys[$row])
                    && preg_match('/'.$manips.'/i', $querys[$row])){
                    $temp = preg_replace('/(%dqt%)/i', '\"', $querys[$row]);
                    $result[] = preg_replace('/%semi%/i', ';', $temp);
                }
            }
        }

        return ($result);
    }

    /**
     * ファイルからクエリを読み込んで実行する
     *
     * @access public
     * @param string $filename ファイル名
     * @return array 実行結果情報
     */
    public function readQuery($filename)
    {
        /* ファイルの読み込み */
        $fp = @fopen($filename, "r");
        if (!$fp){
            return "";
        }
        $query = "";
        $fsize = @filesize($filename);
        if ($fsize) {
            $query = fread($fp, $fsize);
        } else {
            while (!feof($fp)){
                $query .= fread($fp, 1024);
            }
        }
        fclose($fp);

        /* クエリを解析し配列に */
        $objdb = RSL_db::Instance();
        $querys = RSL_db::explodeQuery($query);

        /* クエリを配列毎に実行 */
        $count = 0;
        $affected = 0;
        $message = "";
        foreach ($querys as $query){
            $result = $objdb->query($query);
            $count += 1;
        } // foreach ($querys as $query)

        $results = array();
        $results['count'] = count($querys);

        return ($results);
    }
} // RSL_dbの終了

/**
 * セミコロンを置き換える(preg_replace_callback)
 *
 * @access public
 * @param string $matches マッチ文字の格納配列
 * @return string 置き換えた文字
 */
function remove_semicolon($matches)
{
    return preg_replace("/;/", '%semi%', $matches[0]);
}
?>