<?php
/* ========================================================================
 - [query/query.php]
 - 内容：Query実行
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rsl_pager.php';
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * クエリ
     * @var string
     */
    private $query = "";

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'query/query.tpl';
        $this->addCss('common.css');
        $this->query = empty($_POST['query'])?$this->dbinfo->getQuery():$_POST['query'];
        $this->query = stripslashes($this->query);

        /* ファイルからクエリを設定 */
        $this->set_file2query();

        /* クエリ実行 */
        if (!empty($_REQUEST['do_query']) && !empty($this->query)){
            $this->dbinfo->setQuery($this->query);

            if (RSL_db::isManip($this->query)){
                $this->query_manip();
                $this->Assign('query_manip', true);
            } else {
                $this->query_select();
                $this->Assign('query_select', true);
            }
        }
        /* クエリの消去 */
        if (!empty($_REQUEST['do_clear'])){
            $this->dbinfo->setQuery('');
            $this->query = '';
        }

        $this->Assign('query', $this->query);
    }

    /**
     * ファイルからクエリを設定
     *
     * @access private
     * @return void
     **/
    private function set_file2query()
    {
        if (!isSet($_FILES['sqlfile'])) {
            return ;
        }
        /* MIME TYPEの判定 */
        if (!preg_match("/text/i", $_FILES['sqlfile']['type'])){
            return ;
        }

        $query = '';
        $fp = @fopen($_FILES['sqlfile']['tmp_name'],'r');
        if ($fp){
            while (!feof($fp)){
                $query .= fread($fp, 1024);
            }
            fclose($fp);
        }
        $this->query = $query;
    }

    /**
     * SELECT文以外の実行
     *
     * @access private
     * @return void
     **/
    private function query_manip()
    {
    	$query = mb_convert_encoding($this->query, $this->dbinfo->getEncode(), 'UTF-8');
        $querys = RSL_db::explodeQuery($query);
        
        $this->objdb->beginTransaction();
        $this->transaction = true;
        foreach ($querys as $sql){
            $this->objdb->query($sql); 
        }
        $this->objdb->commit();
        $this->transaction = false;
        
        $result = count($querys).'行のクエリを実行しました。';
        $this->Assign('result', $result);

        $this->Assign('name', $this->dbinfo->getTableName());
        $this->dbinfo->setTableName('');
    }

    /**
     * SELECT文の実行
     *
     * @access private
     * @return void
     **/
    private function query_select()
    {
        $offset = empty($_REQUEST['offset'])?0:$_REQUEST['offset'];

        $objpgr = new RSL_pager($this->objdb, $offset, 20);    // クラスの生成
        $objpgr->setSql($this->query);

        /* ページ情報の取得 */
        $page = array(
            'infos'=> $objpgr->getInfo(),
            'pagers'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        /* データの取得 */
        $result = $objpgr->getValues();
        if (empty($result)){
            return $this->Assign('nolist', true);
        }

        /* htmltemplate用にデータを整形 */
        $list = array();
        $cols = array();
        foreach ($result as $row){
            $cols = array();
            foreach ($row as $key=>$column){
            	$column = mb_convert_encoding($column, 'UTF-8', $this->dbinfo->getEncode());
                $cols[] = array('value'=>$column);
            }
            $list[] = array('column'=>$cols);
        }

        /* フィールド名の設定 */
        $cols = array();
        foreach ($row as $key=>$column){
            $cols[] = array('name'=>$key);
        }
        $this->Assign('column', $cols);

        /* 一つのテーブルによるSELECT文 */        
        if ($this->is_single_table()){
            $objpgr->setParsed('field','rowid');
            $result = $objpgr->getValues();
            foreach ($result as $row=>$cols){
                $list[$row]['rowid'] = $cols['rowid'];
            }
            $this->Assign('is_single', true);
        }
        $this->Assign('pager', $list);
    }

    /**
     * SELECT文に使われているテーブルが一つか
     *
     * @access private
     * @return boolean
     **/
    private function is_single_table()
    {
        $sql_parsed = RSL_db::parseSql($this->query);
        if (empty($sql_parsed['table'])){
            return false;
        }

        $table = preg_replace("/\s|\t/i", '', $sql_parsed['table']);
        $tables = explode(',',$table);
        if (count($tables) > 1){
            return false;
        }
        $table = $tables[0];

        /* テーブルか判定 */
        $sql = "SELECT count(name) FROM sqlite_master WHERE type='table' AND name='".$table."'";
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $result = $stmt->fetchSingle();
        
        if (empty($result)){
            return false;
        }

        $this->Assign('name', $table);

        return true;
    }
} // webapp
?>
