<?php
/* ========================================================================
 - [rsl_htmltpl.php]
 - 内容：HTMLのテンプレート出力
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2003-2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/08] テンプレート引数管理にSmaty風のメンバ関数を導入
 -      [2003/12/18] version 0.1
 -      [2003/12/10] 作成
 - ======================================================================== */

require_once LIB_DIR.'HTML/Template/htmltemplate.inc';

/**
 * HTMLのテンプレート出力
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package RKT_htmltpl
 * @access public
 * @version 2.0
 */
class RSL_htmltpl
{
    /**
     * テンプレート引数
     * @var array
     */
    private $arg = array();

    /**
     * BASE用テンプレート引数
     * @var array
     */
    private $base = array();

    /**
     * スタイルシート読み込みファイル数
     * @var array
     */
    private $css_names = array();

    /**
     * JavaScript読み込みファイル数
     * @var array
     */
    private $js_names = array();

    /**
     * テンプレートファイル
     * @var string
     */
    protected $template_file = '';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        $this->init_tplargs();
    }

    /**
     * テンプレート引数の初期化
     *
     * @access private
     * @return void
     */
    private function init_tplargs()
    {
        $this->base['copyright'] = COPYRIGHT;
        $this->base['self'] = $_SERVER['PHP_SELF'];
        $this->arg['base']['self'] = $_SERVER['PHP_SELF'];
    }

    /**
     * テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     * @return void
     */
    public function Assign($tpl_var,$value)
    {
        $this->arg[$tpl_var] = $value;
    }

    /**
     * BASE用テンプレートへ変数を設定
     *
     * @access public
     * @param array|string $tpl_var the template variable name(s)
     * @param mixed $value the value to assign
     * @return void
     */
    public function baseAssign($tpl_var,$value)
    {
        $this->base[$tpl_var] = $value;
    }

    /**
     * スタイルシート外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    public function addCss($file)
    {
        $this->base['css'][]['file'] = $file;
    }

    /**
     * JavaScript外部読み込みの追加
     *
     * @access public
     * @param string $file ファイルの名前
     * @return void
     */
    public function addJavas($file)
    {
        $this->base['javas'][]['file'] = $file;
    }

    /**
     * セレクトタグリストの取得
     *
     * @access public
     * @param array $values
     * @param mixed $selected
     * @return array
     **/
    public function getSelectList($values,$selected)
    {
        $list = array();
        $row = 0;
        foreach ($values as $value=> $label){
            $list[] = array(
                    'value'=> $value,
                    'label'=> $label,
                    'selected'=> ''
                );
            $value2row[$value] = $row;
            $row++;
        }
        
        if (isSet($value2row[$selected])){
            $list[$value2row[$selected]]['selected'] = ' selected';
        }
        return $list;
    }

    /**
     * ラジオボタンリストの取得
     *
     * @access public
     * @param string $name
     * @param array $values
     * @param mixed $selected
     * @return array
     **/
    public function getRadioList($name,$values,$checked)
    {
        $list = array();
        $row = 0;
        foreach ($values as $value=> $label){
            $list[] = array(
                    'value'=> $value,
                    'label'=> $label,
                    'id'=> $name.$row,
                    'checked'=> ''
                );
            $value2row[$value] = $row;
            $row++;
        }
        
        if (isSet($value2row[$checked])){
            $list[$value2row[$checked]]['checked'] = ' checked';
        }
        return $list;
    }

    /**
     * デザインの出力
     *
     * @access public
     * @param string $file
     * @return void
     */
    public function Output($file)
    {
        HtmlTemplate::t_include(TEMPLATE_DIR.$this->template_file,$this->arg);
    }

    /**
     * 合成デザインの出力
     *
     * @access public
     * @param string $file
     * @return void
     */
    public function mixOutput()
    {
        $buff = htmltemplate::t_buffer(TEMPLATE_DIR.$this->template_file,$this->arg);
        $this->base['content'] = $buff;
        HtmlTemplate::t_include(TEMPLATE_DIR."base.tpl",$this->base);
    }    
}
// RSL_htmltplの終了
?>
