<?php
/* SVN FILE: $Id: entry.php 621 2008-07-20 03:49:24Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 621 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-20 12:49:24 +0900 (日, 20 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require LIB_DIR.'rktAuth/OpenIDInterface.php';

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 621 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-20 12:49:24 +0900 (日, 20 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Plugin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    protected $models = array(
        'manip'=> array(
            'oid_openid',
        ),
        'view'=> array(
        ),            
    );

    /**
     * oid_openid モデルオブジェクト
     * @var object 
     */
    protected $oid_openid = null;

    /**
     * URIアクション
     * @var string 
     */
    protected $action = null;

    /**
     * Auth_OpenIDInterface オブジェクト
     * @var object 
     */
    private $_openid = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->_openid = new Auth_OpenIDInterface(
                                BASE_URL, 
                                HTTP_ACTION.'plugin/hitsuji/OpenID/entry/finish/');
    }

    /**
     * 実行処理
     *
     * @access protected
     * @return void
     **/
    protected function action()
    {
        /* ゲストはアクセス拒否 */
        if ($this->account['status'] == STATUS_GUEST){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }

        if ($this->action == 'request'){
            $required = array(      // 必須項目
                'email',
                'nickname',
            );
            $optional = array(      // オプション
                'fullname',
                'gender',
                'dob',
            );
            $this->_openid->setAuthRequest($required, $optional, $this->identifier);
            $this->_openid->authAction();
        } elseif ($this->action == 'finish'){
            $this->_openid->setResponse();

            $openid = $this->_openid->getOpenID();
            $status = $this->_openid->getResponseStatus();

            $this->objvew->assign('openid', htmlentities($openid));
            $this->objvew->assign('status', $status);
            
            $this->_entryOpenID();
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'action'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'identifier'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * OpenIDの登録
     *
     * @access private
     * @return void
     **/
    private function _entryOpenID()
    {
        if ($this->_openid->getResponseStatus() != Auth_OpenID_SUCCESS){
            return ;
        }

        $now    = date('Y-m-d H:i:s');
        $openid = $this->_openid->getOpenID();
        $parsed = parse_url($openid);
        $hashed = RKT_Crypt::getHashed($openid);

        $this->oid_openid->setValue('hashed_openid', $hashed, RKT_Model::CONDITION);
        $this->oid_openid->setInitValue();

        $this->oid_openid->setValue('modified',      $now);
        $this->oid_openid->setValue('last_login',    $now);
        $this->oid_openid->setValue('regist_date',   $now);
        $this->oid_openid->setValue('ref_account',   $this->account['id']);
        $this->oid_openid->setValue('host',          $parsed['host']);

        $this->oid_openid->manip();
    }
} // class Controller
?>
