<?php
/* SVN FILE: $Id: config.php 614 2008-07-18 15:17:21Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 614 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-19 00:17:21 +0900 (土, 19 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 614 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-19 00:17:21 +0900 (土, 19 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Admin_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
        ),            
    );

    /**
     * des_theme モデルオブジェクト
     * @var object 
     */
    public $des_theme = null;

    /**
     * 管理者メールアドレス
     * @var string
     */
    protected $administrator = null;

    /**
     * SNS名
     * @var string 
     */
    protected $sns_name = null;

    /**
     * 著作権表示
     * @var string 
     */
    protected $copyright = null;

    /**
     * 招待フラグ
     * @var integer 
     */
    protected $system_invite = null;

    /**
     * デフォルトテーマ
     * @var integer 
     */
    protected $default_theme = null;

    /**
     * アマゾンアクセスID
     * @var string 
     */
    protected $amazon_associateid = null;

    /**
     * ぐるなびアクセスキー
     * @var string 
     */
    protected $gnavi_access_key = null;


    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/admin/master.tpl');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $result = false;
        if ($this->checked_nonce){
            if ($this->objrqt->getValidate()){
                $result = true;
                $this->_replaceDefine();
            } else {
                $this->objvew->assign('alert', $this->objrqt->getAlerts());
            }
        } // if (!empty($_POST['manip']))

        $this->objvew->assign('complete', $result);

        $themes = $this->objmdl->getReferenceList('des_theme', 'id', 'theme');
        $this->objvew->assign('themes', $themes);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'administrator'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
            ),
            'sns_name'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'copyright'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'system_invite'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
            'default_theme'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
            'amazon_associateid'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'gnavi_access_key'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
        );
    }

    /**
     * 定義値の置換
     *
     * @access private
     * @return boolean  データ操作結果
     */
    public function _replaceDefine()
    {
        /* ファイルの中身を取得 */
        $buffer = file_get_contents(BASE_DIR.'config.php');

        $this->values['system_invite'] = empty($this->values['system_invite'])?'FALSE':'TRUE';
        $this->values['used_smtp']     = empty($this->values['used_smtp'])?'FALSE':'TRUE';
        $this->values['smtp_auth']     = empty($this->values['smtp_auth'])?'FALSE':'TRUE';

        foreach ($this->conditions as $key=>$_tmp){
            $value = $this->$key;

            $key = strtoupper($key);
            if ('SYSTEM_INVITE' === $key){
                $buffer = preg_replace(
                                "/define\s*\('SYSTEM_INVITE',\s*(0|1|TRUE|FALSE)\);/",
                                "define('SYSTEM_INVITE', ".$value.");",
                                $buffer,
                                1);
            } elseif ('USED_SMTP' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                "define('".$key."', ".$value.");",
                                $buffer,
                                1);
            } elseif ('SMTP_AUTH' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                "define('".$key."', ".$value.");",
                                $buffer,
                                1);
            } elseif ('COPYRIGHT' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*\".*\"\);/",
                                "define('".$key."', \"".$value."\");",
                                $buffer,
                                1);
            } else {
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*'.*'\);/",
                                "define('".$key."', '".$value."');",
                                $buffer,
                                1);
            }
        } // foreach ($this->values as $key=>$value)
        
        $handle = fopen(BASE_DIR.'config.php', 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $buffer);
        fclose($handle);

        return true;
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function _setTheme()
    {
    }
} // class Controller
?>
