<?php
/* SVN FILE: $Id: friendadd.php 600 2008-07-12 17:56:37Z bb_yujiro $ */
/**
 * Model_Manip Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 600 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-13 02:56:37 +0900 (日, 13 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 600 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-13 02:56:37 +0900 (日, 13 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Member_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
            'fri_friends',
        ),
        'view'=> array(
        ),            
    );

    /**
     * fri_friends モデルオブジェクト
     * @var object 
     */
    public $fri_friends = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->fri_friends->setValue('ref_account', $this->account['id'], RKT_Model::CONDITION);
        $this->fri_friends->setValue('ref_friend',  $this->member['id'],  RKT_Model::CONDITION);
        $this->fri_friends->setValue('status',      STATUS_FRIEND_THROW);
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $id = $this->fri_friends->getCurID();
        $this->objvew->assign('id', $id);
        
        if ($this->account['status'] == STATUS_GUEST){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        if ($this->account['id'] == $this->member['id']){
            throw new RKT_Exception(RKT_Exception::ACCESS_DENIED);
        }
        $this->objvew->setRichEditor();
    }
} // class Controller
?>
