<?php
/* SVN FILE: $Id: community.php 594 2008-07-10 14:45:46Z bb_yujiro $ */
/**
 * 表紙
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 594 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-10 23:45:46 +0900 (木, 10 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 594 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-07-10 23:45:46 +0900 (木, 10 7 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Community_Controller extends RKT_Controller
{
    /**
     * 各種ID
     * @var integer
     */
    protected $id = null;

    /**
     * コミュニティ情報
     * @var array
     */
    protected $community = null;

    /**
     * 可視範囲
     * @var integer
     */
    protected $visible = null;

    /**
     * 活動権限
     * @var integer
     */
    protected $permission = null;

    /**
     * コントローラの読み込み
     *
     * @access public
     * @return object
     **/
    public function &getController($group, $module, $page)
    {
        $controller = array (
            'article'=>       array(    // 記事
                'list'=>        true,   // 一覧
                'search'=>      true,   // 検索
                'post'=>        true,   // トピック作成
                'trackback'=>   true,   // トラックバック
                'trackbacks'=>  true,   // トラックバック一覧
                'view'=>        true,   // 表示
            ),
            'event'=>       array(      // コミュニティ記事
                'calendar'=>    true,   // イベントカレンダー
                'entries'=>     true,   // イベント参加者
                'list'=>        true,   // サマリー
                'post'=>        true,   // イベント作成
                'report'=>      true,   // レポート
                'reports'=>     true,   // レポート一覧
                'search'=>      true,   // 検索
                'send'=>        true,   // 参加者へ通知
                'view'=>        true,   // 表示
            ),
            'forum'=>       array(      // フォーラム
                'comment'=>     true,   // コメント
                'comments'=>    true,   // コメント一覧
                'list'=>        true,   // 一覧
                'search'=>      true,   // 検索
                'post'=>        true,   // トピック作成
                'view'=>        true,   // 表示
            ),
            'setting'=>     array(      // 各種編集
                'community'=>   true,   // コミュニティ編集
                'join'=>        true,   // コミュニティ参加
                'invite'=>      true,   // コミュニティ招待
                'names'=>       true,   // メンバー名簿
                'photo'=>       true,   // 写真のアップロード
                'resign'=>      true,   // コミュニティ退会
                'theme'=>       true,   // テーマ
            ),
            'view'=>        array(      // コミュニティ情報閲覧
                'community'=>   true,   // コミュニテイィ表示
                'footprint'=>   true,   // あしあと
                'member'=>      true,   // メンバー表示
                'search'=>      true,   // 検索
            ),
        );

        if (empty($controller[$module])){
            $module = 'view';
            $page   = 'community';
        }

        if (empty($controller[$module][$page])){
            $module = 'view';
            $page   = 'community';
        }

        $include = $group.DS.$module.DS.$page.'.php';
        include CONTROLLER_DIR.$include;
        
        $objController = new Controller($group.DS.$module.DS.$page.'.tpl');
        return $objController;
    }

    /**
     * グループ毎の初期化
     *
     * @access protected
     * @return void
     **/
    protected function initGrouping()
    {
        $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/community.tpl');
        $this->objvew->setTemplate('sidebar_tpl',  'common/menu/community.tpl');
        $this->objvew->addCss('css/community.css');

        $this->account = RKT_account::exec()->getAccount();

        $this->_setCommunityInfo();
        $this->_setPermission();
        $this->_setVisible();

        $this->objvew->baseAssign('id', $this->id);
        $this->objvew->baseAssign('account', $this->account);
        $this->objvew->baseAssign('community', $this->community);
        $this->objvew->baseAssign('permission', $this->permission);

        if (empty($this->community['ref_theme'])){
            Theme::Id($this->account['ref_theme']);
        } else {
            Theme::Id($this->community['ref_theme']);
        }

        $visibility = array(
            VISIBILITY_PUBLIC=>    _('Public'),
            VISIBILITY_PROTECTED=> _('Members'),
            VISIBILITY_PRIVATE=>   _('Private'),
        );
        $this->objvew->baseAssign('visibility', $visibility);

        $involved = array(
            PERMISSION_MEMBER=>  _('Anyone can be involved'),
            PERMISSION_REQUEST=> _("Leader's Approval"),
        );
        $this->objvew->baseAssign('involved', $involved);

        $visibility_icon = array(
            VISIBILITY_PUBLIC=>    ('world.gif'),
            VISIBILITY_PROTECTED=> ('user.gif'),
            VISIBILITY_PRIVATE=>   ('group_key.gif'),
        );
        $this->objvew->baseAssign('visibility_icon', $visibility_icon);

        /* アクセスログ */
        RKT_access::exec()->access(RKT_access::TARGET_COMMUNITY, 
                        $this->community['id'], $this->account['id']);

        /* カテゴリリスト */
        $categories = $this->objmdl->getReferenceList('com_category', 'ref_genre,sort');
        $this->objvew->baseAssign('categories', $categories);

        /* アクセスブロック */
        $this->_accessBlock();
    }

    /**
     * メンバー情報の読み込み
     *
     * @access private
     * @return void
     **/
    private function _setCommunityInfo()
    {
        /* パスインフォからIDを取得 */
        $condition = array(
            'type'=>     'number',
            'option'=>   array(),            
            'required'=> false,
            'pic_up'=>   'PathArgs'
        );
        if ($this->objrqt->catchValidate('id', $condition)){
            $this->id = $this->objrqt->getRequest('id');
        }
        
        $tables = array (
            'article'=>     array(      // 記事
                'trackback'=>  'com_article',
                'view'=>       'com_article',
            ),
            'event'=>       array(      // イベント
                'entries'=> 'com_event',
                'report'=>  'com_event',
                'send'=>    'com_event',
                'view'=>    'com_event',
            ),
            'forum'=>       array(      // フォーラム
                'comment'=> 'com_topic',
                'view'=>    'com_topic',
            ),
        );
        $name = array (
            'article'=> 'article',
            'event'=>   'event',
            'forum'=>   'topic',
        );

        /* パスインフォからモジュール名を取得 */
        $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
        $args   = explode('/', $path_info);
        $module = $args[PATH_INFO_MODULE];
        $page   = $args[PATH_INFO_PAGE];

        if (empty($tables[$module][$page])){
            $ref_community = $this->id;
        } else {
            $name = $name[$module];
            $row  = RKT_DB::getRow($tables[$module][$page], $this->id);
            $this->$name = $row;
            $ref_community = $row['ref_community'];
        }
        if (!empty($ref_community)){
            $this->community = RKT_DB::getRow('com_community', $ref_community);
        }
        
        /* コミュニティ情報なし */
        if (empty($this->community)){
            $this->community = array(
                    'id'           => 0,
                    'regist_date'  => '2008-05-22 12:10:01',
                    'ref_account'  => 0,
                    'avail'        => STATUS_DISABLE,
                    'community'    => 'Default',
                    'ref_category' => 1,
                    'visibility'   => VISIBILITY_PRIVATE,
                    'involved'     => PERMISSION_REQUEST,
                    'topic_flag'   => PERMISSION_LEADER,
                    'event_flag'   => PERMISSION_LEADER,
                    'article_flag' => PERMISSION_LEADER,
                    'ref_region'   => 1,
                    'comment'      => '',
                    'member_num'   => 0,
                    'access_num'   => 0,
            );            
        }
    }

    /**
     * メンバー権限の設定
     *
     * @access private
     * @return void
     **/
    private function _setPermission()
    {
        $this->visible = VISIBILITY_PUBLIC;         // ネット上に公開
        if (empty($this->community)){
            return ;
        }

        /* 参加者判定 */
        $condition = array(
            'ref_community'=> $this->community['id'],
            'ref_account'=>   $this->account['id']
        );
        $row = RKT_DB::getRow('com_names', $condition);
        if (empty($row['status'])){
            return ;
        }
        if ($row['status'] & PERMISSION_MEMBERS){
            $this->permission = PERMISSION_MEMBER;
        }
        $this->permission |= $row['status'];
    }

    /**
     * 可視範囲の設定
     *
     * @access private
     * @return void
     **/
    private function _setVisible()
    {
        $this->visible  = VISIBILITY_PUBLIC;      // ネット上に公開
        if (empty($this->account)){
            return ;
        }

        /* 会員判定 */
        if ($this->account['status'] == STATUS_GUEST){
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/public.tpl');
            return ;
        }
        $this->visible |= VISIBILITY_PROTECTED;

        /* コミュニティメンバー判定 */
        if ($this->permission & PERMISSION_MEMBERS){
            $this->visible |= VISIBILITY_PRIVATE;
        }

        /* 管理者判定 */
        if ($this->permission & PERMISSION_LEADER){
            $this->visible |= VISIBILITY_HIDDEN;
        }
    }

    /**
     * アクセスブロック
     *
     * @access private
     * @return void
     **/
    private function _accessBlock()
    {
        /* コミュニティが存在しない */
        if (empty($this->id)){
            return ;
        }
        /* コミュニティ停止 */
        if ($this->community['avail'] == STATUS_ENABLE){
            return ;
        }

        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/profile.tpl');
        if ($this->account['status'] == STATUS_GUEST){
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/public.tpl');
        } else {
            $this->objvew->setTemplate('groupbar_tpl', 'common/menuBar/private.tpl');
        }
        $this->objvew->setContentFile('common'.DS.'error'.DS.'access.tpl');
        $this->objvew->baseAssign('member',  $this->account);
        $this->objvew->addCss('css/private.css');
    }
} // class Controller
?>
