<?php
/* SVN FILE: $Id: rkt_functions.php 573 2008-06-10 04:28:44Z bb_yujiro $ */
/**
 * 関数定義
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @package         hitSuji
 * @version         $Revision: 573 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-10 13:28:44 +0900 (火, 10 6 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Gettextエミュレーション
 *
 * @copyright   Copyright &copy; 2004-2005, Katsumi Saito <katsumi@jo1upk.ymt.prug.or.jp>
 * @version     $Id: rkt_functions.php 573 2008-06-10 04:28:44Z bb_yujiro $
 * @license     http://opensource.org/licenses/gpl-license.php GNU Public License
 * @link        http://jo1upk.blogdns.net/saito/
 */
if (! extension_loaded('gettext')) {
    include LIB_DIR.'gettext/gettext.php';
}

/**
 * 現在のドメインのメッセージを出力
 *
 * @access public
 * @param string $message
 * @return string
 */
function _e($message) 
{
    echo _($message);
}

/**
 * メッセージを出力
 *
 * @access public
 * @param string $message
 * @return void
 */
function e($message) 
{
    echo $message;
}

/**
 * パスインフォ付の自URLの取得
 *
 * @access private
 * @return string
 */
function getUrlSelf()
{
    $self = $_SERVER['REQUEST_URI'];
    $needle = array(
        'QUERY_STRING'=>   '/',
        'PATH_INFO'=>      '?',
        'ORIG_PATH_INFO'=> '?',
    );
    $addstr = array(
        'QUERY_STRING'=>   '/',
        'PATH_INFO'=>      '',
        'ORIG_PATH_INFO'=> '',
    );

    $pos = strrpos($self, $needle[PATH_INFO_KEY]);
    if (!empty($pos)){
        $self = substr($self, 0, $pos);
    }

    return $self.$addstr[PATH_INFO_KEY];
}

/**
 * メッセージを出力
 *
 * @access public
 * @param string $message
 * @return void
 */
function eNl2br($message) 
{
    echo $message;
}

/**
 * 第1引数が空なら第2引数を出力
 *
 * @access public
 * @param string $message
 * @param string $default
 * @return string
 */
function ifNull($message, $default) 
{
    return empty($message)? $default:$message;
}

/**
 * 第1引数が空なら第2引数を出力
 *
 * @access public
 * @param string $date
 * @param string $format
 * @return string
 */
function fDate($date, $format) 
{
    if (empty($date)){
        return '';
    }
    $date = joinDate($date);
    $timestamp = strtotime($date);
    return date($format, $timestamp);
}

/**
 * 第1引数が空なら第2引数を出力
 *
 * @access public
 * @param string $date
 * @param string $format
 * @return string
 */
function eDate($date, $format='Y-m-d') 
{
    echo fDate($date, $format);
}

/**
 * 年齢変換
 *
 * @access public
 * @param string $date
 * @return string
 */
function fAge($date) 
{
    if (empty($date)){
        return '';
    }
    if (is_numeric($date)){
        return $date;
    }
    $timestamp = strtotime($date);
    $birthday  = date('Ymd', $timestamp);

    $now  = date('Ymd');
    
    return intval(($now - $birthday)/10000);
}

/**
 * 年齢の出力
 *
 * @access public
 * @param string $date
 * @return string
 */
function eAge($date) 
{
    echo fAge($date);
}

/**
 * 配列の日付データを文字列に
 *
 * @access public
 * @parmas array $dates 日付データ
 * @return string
 */
function joinDate($dates)
{
    if (!is_array($dates)){
        return $dates;
    }
    $result  = empty($dates['year'])? 0:$dates['year'];
    $result .= '-';
    $result .= empty($dates['month'])?0:sprintf('%02d', $dates['month']);
    $result .= '-';
    $result .= empty($dates['day'])?  0:sprintf('%02d', $dates['day']);

    $needle = array('hour','minute','seconds');
    if (isSet($dates['hour']) && isSet($dates['minute']) && isSet($dates['seconds'])){
        $result .= ' ';
        $result .= empty($dates['hour'])?   0:$dates['hour'];
        $result .= ':';
        $result .= empty($dates['minute'])? 0:sprintf('%02d', $dates['minute']);
        $result .= ':';
        $result .= empty($dates['seconds'])?0:sprintf('%02d', $dates['seconds']);
    }


    $pos = strpos($result, '0-0-0');
    if ($pos !== false){
        return null;
    }
    
    return $result;
}

/**
 * 文字列の日付データを配列に
 *
 * @access public
 * @parmas string $date 日付データ
 * @return array
 */
function splitDate($date)
{
    if (!is_string($date)){
        return $date;
    }

    if (preg_match('/[\/: -]/i', $date)){
        $dates = split ('[/: -]', $date);
    } else {
        $dates = array (
            substr($date, 0, 4),
            substr($date, 4, 2),
            substr($date, 6, 2),
            substr($date, 8, 2),
            substr($date, 10, 2),
            substr($date, 12, 2),
        );
    }

    $result = array(
        'year'=>$dates[0],
        'month'=>$dates[1],
        'day'=>$dates[2],
    );
    
    if (!empty($dates[3])){
        $result['hour'] = $dates[3];
        $result['minute'] = $dates[4];
        $result['seconds'] = $dates[5];
    }
    return $result;
}

/**
 * JSON 形式に変換
 *
 * @access public
 * @parmas string $value
 * @return string
 */
if (!function_exists('json_encode')) {
    function json_encode($value)
    {
        static $json;
    
        if (empty($json)){
            include LIB_DIR.'PEAR/Services/JSON.php';
            $json = new Services_JSON();
        }
        return $json->encode($value);    
    }
} // if (!function_exists('json_encode'))
?>
