<?php
/* SVN FILE: $Id: upload.php 578 2008-06-11 22:26:15Z bb_yujiro $ */
/**
 * 動画コメントの登録
 *
 * PHP versions 5
 *
 *      Xoops ModuleのCinemaruをhitSujiプラグインに移植したものです。
 *      Xoops用の本家は http://cinemaru.jp/ を参照下さい。
 *
 * Licensed under The GNU General Public License v2
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        Plugin
 * @package         Cinemaru hitSuji Plugin
 * @copyright       Copyright (c) 2008 Cinemaru Project
 * @link            http://cinemaru.jp/
 * @author          時田正彦 <BQB04357@nifty.ne.jp>
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 578 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-06-12 07:26:15 +0900 (木, 12 6 2008) $
 * @license         http://www.gnu.org/licenses/gpl-2.0.txt The GPLv2
 */

require dirname(__FILE__).'/../../../config.php';
require LIB_DIR.'rkt_functions.php';
require LIB_DIR.'rkt_db.php';
require LIB_DIR.'rkt_crypt.php';
require LIB_DIR.'rkt_session.php';
require LIB_DIR.'rkt_account.php';
require LIB_DIR.'rkt_image.php';


/* 言語設定の実行 */
setlocale(LC_ALL, LANGUAGE);
bindtextdomain(TEXT_DOMAIN, LOCALE_DIR);
textdomain(TEXT_DOMAIN);
bind_textdomain_codeset(TEXT_DOMAIN, ENCODE_TYPE);

/**
 * アップロードされた情報をメンバ変数へセットする
 *
 * @access public
 * @param string $key
 * @return boolean 成功時真
 */
function catchFile()
{
    if (!isSet($_FILES['mfile'])) {
        return 'none';
    }
    if ($_FILES['mfile']['error'] != UPLOAD_ERR_OK) {
        return 'error';
    }
    /* ファイルの種類が動画/mp3か判定 */
    // if (!preg_match('/flv|mp3/i', $_FILES['mfile']['type'])){
    if (!preg_match('/flv|mp3|jpg|gif|png/i', $_FILES['mfile']['name'])){
        return '';
    }
    $ref_account = RKT_account::exec()->getAccountID();
    $temp        = md5($ref_account.time());
    $name        = substr($temp, rand(0,25), 6);
    $idpack      = intval($ref_account / 1000);
    $initial     = substr($name, 0, 1);

    $path = 'cinemaru/uploads/'. $idpack.'000/'.$ref_account.'/'.$initial.'/';

    /* 拡張子の取得 */
    $pos = strrpos($_FILES['mfile']['name'], '.');
    if ($pos !== false){
        $extension = substr($_FILES['mfile']['name'], $pos+1);
    } else {
        $extension = '';
    }
    $extension = strtolower($extension);
    
    /* ディレクトリの確認・作成 */
    if (!file_exists(RESOURCE_DIR.$path)){
        mkdir(RESOURCE_DIR.$path, 0755, true);
    }

    /* ファイルの種類が画像か判定 */
    $filename  = $path.$name.'.'.$extension;
    $pos       = strpos($_FILES['mfile']['type'], 'image');
    if (false !== $pos){
        /* リサイズ保存 */
        $objimg = RKT_Image::getInstance();
        $objimg->readImage($_FILES['mfile']['tmp_name']);
        $objimg->resize(PHOTO_LARGE_SIZE, PHOTO_LARGE_SIZE);
        $objimg->save(RESOURCE_DIR.$filename);
    } else {
        /* アップロードファイルの移動 */
        if (!move_uploaded_file($_FILES['mfile']['tmp_name'], RESOURCE_DIR.$filename)) {
            return '';
        }
    } // if (false !== $pos)


    return $filename;
}

$nonce = RKT_Crypt::getNonce('manipNonce');
$request_nonce = empty($_POST['_mpnnc'])? '':$_POST['_mpnnc'];

if ($nonce === $request_nonce){
    $filename = catchFile();
}
$pkey = empty($_REQUEST['pkey'])? '':$_REQUEST['pkey']
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja" lang="ja">
<head>
<meta http-equiv="content-type" content='text/html; charset="utf-8"' />
<style type="text/css">
<!--
BODY	{
    margin: 0;
    padding: 0;
}
AREA	{
	cursor: pointer;
	cursor: hand;
}
-->
</style>
</head>
<body>
<?php if (!empty($filename)): ?>
<script language="javascript" type="text/javascript">
parent.YAHOO.util.Dom.get('<?php e($pkey); ?>').value = '<?php e(BASE_URL.'resource/'.$filename); ?>';
</script>
<?php endif; ?>
<form method="post" enctype="multipart/form-data" action="<?php e(BASE_URL); ?>resource/cinemaru/upload.php">
	<input type="hidden" name="_mpnnc" value="<?php e($nonce); ?>" />
	<input type="hidden" name="pkey" value="<?php e($pkey); ?>" />
	<input type="file" name="mfile" size="20" />
	<input type="submit" name="manip" value="<?php _e('Upload'); ?>" style="width:100px;" />
</form>
</body>
<html>