<?php
/* SVN FILE: $Id: review.php 162 2008-04-23 00:34:48Z bb_yujiro $ */
/**
 * レヴュー用商品を表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 162 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:48 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * レヴュー用商品を表示
 *
 * @access public
 * @param integer   $ref_account
 * @param string    $service
 * @param string    $item_code
 * @return void
 **/
function hitsuji_review($ref_account, $service, $item_code)
{
    if (empty($service) || empty($item_code)){
        return ;
    }
    $names = array(
        'amazon'=> true,
        'gnavi'=> true,
    );
    $service = empty($names[$service])? 'amazon':$service;
    $func    = 'hitsuji_review_'.$service;
    $item    = call_user_func($func, $item_code);

    print ('<table><tbody><tr>');
    print ('<td>');
    print ('<a href="'.$item['view_url'].'"><img src="'. BASE_URL.'review'.ACTION_STYLE.'/'.$service.'/160/'.$item_code.'.jpg' .'" /></a><br>');
    print ('<a href="'.$item['view_url'].'">'.sprintf(_('More at %s'), $item['atService']) .'</a>');
    print ('</td>');
    print ('<td>');
    print ('<strong>'.$item['title'].'</strong><br>');
    print ($item['comment'].'<br>');
    print ('<a href="'.$item['view_url'].'"><img src="'. BASE_URL.'review'.ACTION_STYLE.'/rating/'.$ref_account.'/'.$item_code.'.gif' .'" /></a><br>');
    print ('</td>');
    print ('</tr></tbody></table>');
} // hitsuji_review

/**
 * Amazon表示
 *
 * @access public
 * @param array $arg
 * @return void
 */
function hitsuji_review_amazon($item_code)
{
    include LIB_DIR.'PEAR/Services/AmazonECS4.php';
    $amazon = new Services_AmazonECS4(AMAZON_TOKEN, AMAZON_ASSOCIATEID);
    $options = array(
        'ResponseGroup'=> 'Small'
    );
    $result = $amazon->ItemLookup($item_code, $options);
    if (PEAR::isError($result)) {
        return null;
    }
    if (empty($result['Item'][0])){
        return null;
    }
    $row = $result['Item'][0];

    $comment  = empty($row['ItemAttributes']['Author'][0])? '':$row['ItemAttributes']['Author'][0].'<br />';
    $comment .= empty($row['ItemAttributes']['Artist'])? '':$row['ItemAttributes']['Artist'].'<br />';
    $comment .= empty($row['ItemAttributes']['Manufacturer'])? '':$row['ItemAttributes']['Manufacturer'].'<br />';
    $comment .= empty($row['OfferSummary']['LowestNewPrice']['FormattedPrice'])? '':$row['OfferSummary']['LowestNewPrice']['FormattedPrice'].'<br />';

    return array(
        'atService'=> 'Amazon',
        'view_url'=>  $row['DetailPageURL'],
        'title'=>     $row['ItemAttributes']['Title'],
        'comment'=>   $comment,
    );
}

/**
 * ぐるなび表示
 *
 * @access public
 * @param array $arg
 * @return void
 */
function hitsuji_review_gnavi($item_code)
{
    include LIB_DIR.'PEAR/Services/Gnavi.php';
    $gnavi = new Services_Gnavi(GNAVI_ACCESS_KEY);
    $options = array(
        'id'=> $item_code
    );
    $gnavi->searchRestaurant($options);
    $result = $gnavi->getResult();
    if (PEAR::isError($result)) {
        return null;
    }
    if (empty($result['rest'])){
        return null;
    }

    return array(
        'atService'=> 'ぐるなび',
        'view_url'=>  $result['rest']['url'],
        'title'=>     $result['rest']['name'],
        'comment'=>   $result['rest']['pr']['pr_short'],
    );
}
?>
