<?php
/* SVN FILE: $Id: relation.php 470 2008-05-22 09:35:38Z bb_yujiro $ */
/**
 * プロフィールを表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 470 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:35:38 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 友達のつながりを表示
 *
 * @access public
 * @param integer   $ref_account
 * @param integer   $ref_member
 * @return void
 **/
function hitsuji_relation($ref_account, $ref_member)
{
    /* 本人以外の場合 */
    if ($ref_account !== $ref_member){
        /* 友達のつながり取得 */
        $condition = array(
            'status'=>      STATUS_FRIEND_CONNECT,
            'ref_account'=> $ref_account,
            'ref_friend'=>  $ref_member
        );
        $friend = RKT_DB::getRow('fri_friends', $condition);
        if (empty($friend['id'])){
            hitsuji_relation_intermediary($ref_account, $ref_member);
        } else {
            $condition = array(
                'ref_account'=> $ref_account
            );
            $self = RKT_DB::getRow('act_profile', $condition, 'nickname');
            print ('<span style="font=size?:0.8em;">'.mb_strimwidth($self['nickname'], 0, 10, '...').'</span>');
            print ('&nbsp;<img src="'.BASE_URL.'resource/img/icons/bullet_go.gif" width="16" height="16" align="absmiddle" alt=">>" />&nbsp;');
        }
    } // if ($ref_account !== $ref_member)
    $condition = array(
        'ref_account'=> $ref_member
    );
    $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');
    print (mb_strimwidth($profile['nickname'], 0, 20, '...'));
} // hitsuji_relation

/**
 * 間接的な友達のつながり取得
 *
 * @access private
 * @param integer   $ref_account
 * @param integer   $ref_member
 * @return void
 */
function hitsuji_relation_intermediary($ref_account, $ref_member)
{
    $sql =
        'SELECT '.
            'direct.ref_friend as friend '.
        'FROM '.
            DB_PREFIX.'fri_friends direct,'.
            DB_PREFIX.'fri_friends near '.
        'WHERE '.
            'direct.ref_account = '.$ref_account.' AND '.
            'near.ref_friend = '.$ref_member.' AND '.
            'direct.status = '.STATUS_FRIEND_CONNECT.' AND '.
            'near.status = '.STATUS_FRIEND_CONNECT.' AND '.
            'direct.ref_friend = near.ref_account';
    $stmt = RKT_DB::exec()->prepare($sql); 
    $stmt->execute(); 
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $stmt->closeCursor();    
    if (empty($result['friend'])){
        return ;
    }

    $condition = array(
        'ref_account'=> $ref_account
    );
    $self = RKT_DB::getRow('act_profile', $condition, 'nickname');

    $condition = array(
        'ref_account'=> $result['friend']
    );
    $profile = RKT_DB::getRow('act_profile', $condition, 'nickname');

    print ('<span style="font=size?:0.8em;">&nbsp;'.mb_strimwidth($self['nickname'], 0, 10, '...').'</span>');
    print ('&nbsp;<img src="'.BASE_URL.'resource/img/icons/bullet_go.gif" width="16" height="16" align="absmiddle" alt=">>" />&nbsp;');
    print ('<a href="'.HTTP_ACTION.'member/personal/profile/'.$result['friend'].'/">');
    print ('<span style="font=size?:0.8em;">'.mb_strimwidth($profile['nickname'], 0, 10, '...').'</span></a>');
    print ('&nbsp;<img src="'.BASE_URL.'resource/img/icons/bullet_go.gif" width="16" height="16" align="absmiddle" alt=">>" />&nbsp;');
}
?>
