<?php
/* SVN FILE: $Id: profile.php 477 2008-05-22 11:34:54Z bb_yujiro $ */
/**
 * プロフィールを表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 477 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 20:34:54 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * プロフィールを表示
 *
 * @access public
 * @param integer   $ref_account
 * @param string    $column
 * @param string    $separator
 * @return void
 **/
function hitsuji_profile($ref_account, $column='nickname', $separator='<br />')
{
    /* プロフィール読み込み */
    $condition = array(
        'ref_account'=> $ref_account
    );
    $profile = RKT_DB::getRow('act_profile', $condition);

    $columns = explode(',', $column);
    foreach ($columns as $column){
        /* 画像情報の読み込み */
        if ($column == 'photo' || $column == 'thumbnail'){
            hitsuji_profile_photo($ref_account, $column, $profile['nickname']);
        } elseif ($column == 'nickname'){
            $nickname = mb_strimwidth($profile['nickname'], 0, 20, '...');
            print ($nickname);
        } elseif ($column == 'intro'){
            HTML::strimWidth($profile['comment']);
        } elseif ($column == 'vSmall'){
            hitsuji_profile_vSmall($ref_account, $column, $profile['nickname']);
        } else {
            print ($profile[$column]);
        }
        print ($separator);
    }
} // hitsuji_profile

/**
 * 写真を表示
 *
 * @access public
 * @param integer   $ref_account
 * @param string    $type
 * @param string    $nickname
 * @return void
 **/
function hitsuji_profile_photo($ref_account, $type, $nickname)
{
    /* 画像情報の読み込み */
    $condition = array(
        'status'=>      STATUS_PHOTO_MAIN,
        'ref_account'=> $ref_account
    );
    $photo  = RKT_DB::getRow('act_photo', $condition);

    if ($type == 'photo'){
        $src    = empty($photo['filename'])? NOPHOTO_LARGE:$photo['filename'];
        $width  = empty($photo['width'])?    PHOTO_LARGE_SIZE:$photo['width'];
        $height = empty($photo['height'])?   PHOTO_LARGE_SIZE:$photo['height'];
        $size   = PHOTO_LARGE_SIZE;
    } else {
        $src    = empty($photo['thumbnail'])? NOPHOTO_SMALL:$photo['thumbnail'];
        $width  = empty($photo['t_width'])?   PHOTO_SMALL_SIZE:$photo['t_width'];
        $height = empty($photo['t_height'])?  PHOTO_SMALL_SIZE:$photo['t_height'];
        $size   = PHOTO_SMALL_SIZE;
    }
    $margin = ($size - $height) / 2;
    $href   = '';

    if (!empty($ref_account)){
        $href = ' href="'.HTTP_ACTION.'member/personal/profile/'.$ref_account.'/"';
    }
    $nickname = str_replace('[m:', '[', $nickname);
    print ('<a'.$href.' title="'.$nickname.'">');
    print ('<img src="'.BASE_URL.$src.'" width="'.$width.'" height="'.$height.'" alt="'.$nickname.'" style="margin: '.$margin.'px auto;" />');
    print ('</a>');
} // hitsuji_profile_photo

/**
 * 小さい写真を表示
 *
 * @access public
 * @param integer   $ref_account
 * @param string    $type
 * @param string    $nickname
 * @return void
 **/
function hitsuji_profile_vSmall($ref_account, $type, $nickname)
{
    /* 画像情報の読み込み */
    $condition = array(
        'status'=>      STATUS_PHOTO_MAIN,
        'ref_account'=> $ref_account
    );
    $photo  = RKT_DB::getRow('act_photo', $condition);

    $src    = empty($photo['v_small'])? NOPHOTO_VSMALL:$photo['v_small'];
    $width  = empty($photo['v_width'])?   PHOTO_VSMALL_SIZE:$photo['v_width'];
    $height = empty($photo['v_height'])?  PHOTO_VSMALL_SIZE:$photo['v_height'];

    print ('<a href="'.HTTP_ACTION.'member/personal/profile/'.$ref_account.'/">');
    print ('<img src="'.BASE_URL.$src.'" width="'.$width.'" height="'.$height.'" alt="'.$nickname.'">');
    print ('</a>');
} // hitsuji_profile_photo
?>
