<?php
/* SVN FILE: $Id: mobileGadget.php 468 2008-05-22 09:34:30Z bb_yujiro $ */
/**
 * 携帯用ガジェット
 *
 * PHP versions 5
 *
 *  Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *  Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 468 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 18:34:30 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

include_once LIB_DIR.'PEAR/HTTP/Request.php';

/**
 * 携帯用ガジェット
 *
 * @access public
 * @param integer   $ref_account
 * @return void
 **/
function hitsuji_mobileGadget($ref_account)
{
    $condition = array(
        'ref_account'=> $ref_account,
        'type'=>        array('<=', GADGET_OUTSIDE),
    );
    $result = RKT_DB::getList('act_gadget', $condition, '*', 'sort');
    if (empty($result)){
        return ;
    }

    foreach ($result as $_row){ 
        if ($_row['type'] == GADGET_INSIDE) {
            hitsuji_mobileGadget_Inside($_row);
        } elseif ($_row['type'] == GADGET_OUTSIDE) {
            hitsuji_mobileGadget_Outside($_row);
        }
    }
} // hitsuji_mobileGadget

/**
 * 内部RSS処理
 *
 * @access public
 * @param array   $gadget
 * @return void
 **/
function hitsuji_mobileGadget_Inside($gadget)
{
    $link = str_replace('/json/', '/', $gadget['source']);
    $cookie = array(
        'name'=>  session_name(),
        'value'=> session_id(),
    );

    $objreq = new HTTP_Request();
    $objreq->setMethod(HTTP_REQUEST_METHOD_GET);
    $objreq->addCookie($cookie['name'], $cookie['value']);
    $objreq->setURL($link.'php/');

    if (PEAR::isError($objreq->sendRequest())) {
        return ;
    }

    $response = $objreq->getResponseBody();
    $result   = @unserialize($response);
    
    if (empty($result)){
        return ;
    }
    $max = intval($gadget['list_number']);
    $num = count($result);
    $max = ($max < $num)? $max:$num;
?>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>">
<tr><td bgcolor="<?php Theme::exec()->bgColumnColor(); ?>" align="center"><font color="<?php Theme::exec()->columnColor(); ?>"><?php e($gadget['title']); ?></font><br></td></tr>
<?php for ($row=0; $row<$max; $row++): ?>
<tr><td bgcolor="<?php Theme::exec()->bgColor(); ?>"><font size="<?php Theme::exec()->fontSize(); ?>">
<?php eDate($result[$row]['modified'], _('m-d')); ?>--<a href="<?php e(trim($result[$row]['link'])); ?>"><?php e($result[$row]['title']); ?></a><?php if (!empty($result[$row]['creator'])): ?>&nbsp;(<?php e($result[$row]['creator']); ?>)<?php endif; ?><br>
</font></td></tr>
<?php endfor; ?>
</table>
<div align="right"><font size="<?php Theme::exec()->fontSize(); ?>">&lt;<a href="<?php e($link); ?>"><?php _e('View More'); ?></a>&gt;|&lt;<a href="<?php e(HTTP_ACTION); ?>private/post/gadget/<?php e($gadget['id']); ?>/"><img src="<?php e(BASE_URL); ?>resource/img/icons/cog.gif" width="16" height="16" alt="&gt;"></a>&gt;</font></div>
<?php
}

/**
 * 外部RSS処理
 *
 * @access public
 * @param array   $gadget
 * @return void
 **/
function hitsuji_mobileGadget_Outside($gadget)
{
    $feed = RKT_DB::getRow('rss_feed', $gadget['ref_feed']);
    if (empty($feed)){
        return ;
    }
    $result   = unserialize($feed['articles']);
    
    if (empty($result)){
        return ;
    }
    $max = intval($gadget['list_number']);
    $num = count($result);
    $max = ($max < $num)? $max:$num;
?>
<table border="0" width="<?php Theme::exec()->mainWidth(); ?>">
<tr><td bgcolor="<?php Theme::exec()->bgColumnColor(); ?>" align="center"><font color="<?php Theme::exec()->columnColor(); ?>"><?php e($gadget['title']); ?></font><br></td></tr>
<?php for ($row=0; $row<$max; $row++): ?>
<tr><td bgcolor="<?php Theme::exec()->bgColor(); ?>"><font size="<?php Theme::exec()->fontSize(); ?>">
<a href="<?php e(trim($result[$row]['link'])); ?>"><?php e($result[$row]['title']); ?></a><?php if (!empty($result[$row]['creator'])): ?>&nbsp;(<?php e($result[$row]['creator']); ?>)<?php endif; ?><br>
</font></td></tr>
<?php endfor; ?>
</table>
<div align="right"><font size="<?php Theme::exec()->fontSize(); ?>">&lt;<a href="<?php e($feed['link']); ?>"><?php _e('View More'); ?></a>&gt;|&lt;<a href="<?php e(HTTP_ACTION); ?>private/post/gadget/<?php e($gadget['id']); ?>/"><img src="<?php e(BASE_URL); ?>resource/img/icons/cog.gif" width="16" height="16" alt="&gt;"></a>&gt;</font></div>
<?php
}
?>
