<?php
/* SVN FILE: $Id$ */
/**
 * Pluginクラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        hitSuji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision$
 * @modifiedby      $LastChangedBy$
 * @lastmodified    $Date$
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Pluginクラス
 *
 * @category        hitSuji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision$
 * @modifiedby      $LastChangedBy$
 * @lastmodified    $Date$
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class hitsuji_mobile extends RKT_plugin
{
    /**
     * キャリア名
     * @var string
     */
    private $_name = 'NonMobile';

    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
        $agent = Net_UserAgent_Mobile::singleton();

        $this->_name = $agent->getCarrierLongName();
    }

    /**
     * リッチエディターボタン追加用JavaScript
     *
     * @access public
     * @return string
     */
    public function editorAddButtonJs()
    {
?>
		var imgConfig = {
			type: 'push', label: '<?php _e('Insert Icon'); ?>', value: 'insertEmoji',
			menu: function() {
				var menu = new YAHOO.widget.Overlay('insertEmoji', {
					width: '230px',
					height: '194px',
					visible: false
				});
				var str = '<iframe src="<?php e(HTTP_ACTION); ?>public/plugin/view/hitsuji/mobile/module/" width="236" height="200" frameborder="0"></iframe>';
				menu.setBody('<div>' + str + '</div>');
				menu.beforeShowEvent.subscribe(function() {
					menu.cfg.setProperty('context', [
						myEditor.toolbar.getButtonByValue('insertEmoji').get('element'),
						'tl', 'bl'
					]);
				});
				menu.render(document.body);
				menu.element.style.visibility = 'hidden';
				return menu;
			}()
		};
		myEditor.toolbar.addButtonToGroup(imgConfig, 'insertitem');
<?php
    }

    /**
     * リッチエディター用CSS
     *
     * @access public
     * @return string
     */
    public function editorCss()
    {
?>
/* Emoji */
.yui-skin-sam .yui-toolbar-container .yui-toolbar-insertEmoji span.yui-toolbar-icon {
	background-image: url( <?php e(BASE_URL); ?>resource/img/icons/emoticon_happy.gif );
	background-position: 1px 0px;
	left: 5px;
}
#insertEmoji {
	border:1px solid #808080;
	padding:5px;
	background-color: #F2F2F2;
}
#insertEmoji a {
	display: block;
	float: left;
	border: 1px solid #F2F2F2;
}
#insertEmoji a:hover {
	border: 1px solid #808080;
}
<?php
    }

    /**
     * エディター用HTML BODY出力エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function outputEditorBody($string)
    {
        return $string;
    }

    /**
     * 出力時へのフィルター
     *
     * @access public
     * @parmas string $value
     * @parmas string $mime_type
     * @return string
     */
    public function outputFilter($body, $mime_type)
    {
        if ($mime_type == 'application/json'){
            return $body;
        }
        $name2html = array(
            'NonMobile'=>'_convertNon',
            'DoCoMo'=>   '_convertHTML',
            'EZweb'=>    '_convertHTML',
            'SoftBank'=> '_convertHTML',
            'WILLCOM'=>  '_convertHTML',
        );
        $method = $name2html[$this->_name];
        $body = call_user_func(array(__CLASS__, $method), $body);

        $name2convert = array(
            'NonMobile'=>'_convertNon',
            'DoCoMo'=>   '_convertToSJIS',
            'EZweb'=>    '_convertToSJIS',
            'SoftBank'=> '_convertZenToHan',
            'WILLCOM'=>  '_convertNon',
        );
        $method = $name2convert[$this->_name];
        $body = call_user_func(array(__CLASS__, $method), $body);

        $body = $this->_convertEmoji($body);
        return $body;
    }

    /**
     * HTML BODY出力用エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function outputHtmlBody($string)
    {
        return $string;
    }

    /**
     * 入力値へのフィルター
     *
     * @access public
     * @parmas mixed $value
     * @parmas string $type
     * @return mixed
     */
    public function requestFilter($value, $type)
    {
        $type2convert = array(
            'string'=>  '_convertEmojiTag',
            'number'=>  '_convertNon',
            'date'=>    '_convertNon',
            'email'=>   '_convertNon',
            'uri'=>     '_convertNon',
        );

        $method = $type2convert[$type];
        $value  = call_user_func(array(__CLASS__, $method), $value);

        return $value;
    }

    /**
     * 独自タグから絵文字へ変換
     *
     * @access private
     * @parmas string $value
     * @return string
     */
    private function _convertEmoji($string)
    {
        include_once LIB_DIR.'rktText/Emoji.php';

        $encoding = RKT_View::getInstance()->getOutputEncoding();
        $objemoji = new Text_Emoji($encoding);

        $fromEncoding = $objemoji->getFromEncoding();
        $to_encoding = array(
            'Tag'=>      'Img',
            'DoCoMo'=>   'DoCoMo',
            'EZweb'=>    'EZweb',
            'SoftBank'=> 'SoftBank',
        );
        $string = $objemoji->convert($string, $to_encoding[$fromEncoding], 'Tag');

        return $string;
    }

    /**
     * 独自タグから絵文字へ変換
     *
     * @access private
     * @parmas string $value
     * @return string
     */
    private function _convertEmojiTag($string)
    {
        if (!is_string($string)){
            return $string;
        }
        include_once LIB_DIR.'rktText/Emoji.php';

        $encoding = RKT_View::getInstance()->getOutputEncoding();
        $objemoji = new Text_Emoji(ENCODE_TYPE, $encoding);

        $string = $objemoji->convertEncoding($string, 'Tag');

        /* 改行変換 */
        $name2nlbr = array(
            'NonMobile'=>'_convertNon',
            'DoCoMo'=>   '_nlToBr',
            'EZweb'=>    '_nlToBr',
            'SoftBank'=> '_nlToBr',
            'WILLCOM'=>  '_nlToBr',
        );
        $method = $name2nlbr[$this->_name];
        $string = call_user_func(array(__CLASS__, $method), $string);

        return $string;
    }

    /**
     * 変換しない
     *
     * @access private
     * @parmas string $string
     * @return string
     */
    private static function _convertNon($string)
    {
        return $string;
    }

    /**
     * XHTML表記からHTML表記へ変換
     *
     * @access private
     * @parmas string $string
     * @return string
     */
    private static function _convertHTML($string)
    {
        $string = str_replace('<label>', '', $string);
        $string = str_replace('</label>', '', $string);
        $string = str_replace('/>', '>', $string);
        $string = preg_replace('/class="[a-z0-9]+"/', '', $string);
    
        return $string;
    }

    /**
     * 内部エンコードからSJISへ変換
     *
     * @access private
     * @parmas string $string
     * @return string
     */
    private static function _convertToSJIS($string)
    {
        $string = mb_convert_kana($string, 'ka', ENCODE_TYPE);
        $string = mb_convert_encoding($string, 'sjis-win', ENCODE_TYPE);
        return $string;
    }

    /**
     * SJISから内部エンコードへ変換
     *
     * @access private
     * @parmas string $string
     * @return string
     */
    private static function _convertToUTF($string)
    {
        $string = mb_convert_encoding($string, ENCODE_TYPE, 'sjis-win');
        return $string;
    }

    /**
     * 全角カタカナから半角カタカナへ変換
     *
     * @access private
     * @parmas string $string
     * @return string
     */
    private static function _convertZenToHan($string)
    {
        $string = mb_convert_kana($string, 'ka', ENCODE_TYPE);
        return $string;
    }

    /**
     * 改行コードを改行タグに変換
     *
     * @access private
     * @parmas string $string
     * @return string
     */
    private static function _nlToBr($string)
    {
        $string = nl2br($string);
        return $string;
    }
} // RKT_plugin
?>
