<?php
/* SVN FILE: $Id$ */
/**
 * Pluginクラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        hitSuji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision$
 * @modifiedby      $LastChangedBy$
 * @lastmodified    $Date$
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Pluginクラス
 *
 * @category        hitSuji
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision$
 * @modifiedby      $LastChangedBy$
 * @lastmodified    $Date$
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class hitsuji_insertHTML extends RKT_plugin
{
    /**
     * コンストラクタ
     *
     * @access public
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * リッチエディターボタン追加用JavaScript
     *
     * @access public
     * @return string
     */
    public function editorAddButtonJs()
    {
?>
		var imgConfig = {
			type: 'push', label: '<?php _e('Insert HTML'); ?>', value: 'insertHtml',
			menu: function() {
				var menu = new YAHOO.widget.Overlay('insertHtml', {
					width: '230px',
					height: '194px',
					visible: false
				});
				var str = '<textarea id="script"></textarea><br /><center><button id="insHtml" type="button"><?php _e('Insert'); ?></button></center>';
				menu.setBody('<div id="insScript">' + str + '</div>');
				menu.beforeShowEvent.subscribe(function() {
					menu.cfg.setProperty('context', [
						myEditor.toolbar.getButtonByValue('insertHtml').get('element'),
						'tl', 'bl'
					]);
				});
				menu.render(document.body);
				menu.element.style.visibility = 'hidden';
				return menu;
			}()
		};
		myEditor.toolbar.addButtonToGroup(imgConfig, 'insertitem');
<?php
    }

    /**
     * リッチエディター用CSS
     *
     * @access public
     * @return string
     */
    public function editorCss()
    {
?>
.yui-skin-sam .yui-toolbar-container .yui-toolbar-insertHtml span.yui-toolbar-icon {
	background-image: url( <?php e(BASE_URL); ?>resource/img/icons/script_code.gif );
	background-position: 1px 0px;
	left: 5px;
}
#insertHtml {
	border:1px solid #808080;
	padding:5px;
	background-color: #F2F2F2;
}
#insertHtml a {
	display: block;
	float: left;
	border: 1px solid #F2F2F2;
}
#insertHtml a:hover {
	border: 1px solid #808080;
}
#script {
	width:224px;
	height:160px;
}
<?php
    }

    /**
     * リッチエディター用JavaScript
     *
     * @access public
     * @return string
     */
    public function editorJavaScript()
    {
?>
	YAHOO.util.Event.onAvailable('insScript', function() {
		YAHOO.util.Event.on('insHtml', 'click', function(ev) {
			var val  = YAHOO.util.Dom.get('script').value;
			val = val.replace('</embed>', '<img src="<?php e(BASE_URL); ?>resource/img/common/plugin.gif"><?php _e('Insert Object'); ?></embed>');
			myEditor.execCommand('inserthtml', val);
			YAHOO.util.Dom.setStyle('insertHtml', "visibility", "hidden");
			YAHOO.util.Event.stopEvent(ev);
		}, myEditor, true);
	});
<?php
    }

    /**
     * エディター用HTML BODY出力エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function outputEditorBody($string)
    {
        return $string;
    }

    /**
     * HTML BODY出力用エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function outputHtmlBody($string)
    {
        return $string;
    }

    /**
     * HTML BODY入力用エフェクト
     *
     * @access public
     * @parmas string $value
     * @return string
     */
    public function requestHtmlBody($string)
    {
        $search = '<img src="'.BASE_URL.'resource/img/common/plugin.gif">'._('Insert Object');
        $string = str_replace($search, '', $string);

        return $string;
    }
} // RKT_plugin
?>
