<?php
/* SVN FILE: $Id: community.php 477 2008-05-22 11:34:54Z bb_yujiro $ */
/**
 * コミュニティを表示
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 477 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-22 20:34:54 +0900 (木, 22 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * コミュニティを表示
 *
 * @access public
 * @param integer   $ref_community
 * @param string    $column
 * @param string    $separator
 * @return void
 **/
function hitsuji_community($ref_community, $column='community', $separator='<br />')
{
    $ref_community = empty($ref_community)? 0:$ref_community;

    /* コミュニティ読み込み */
    $community = RKT_DB::getRow('com_community', $ref_community);
    $columns = explode(',', $column);
    foreach ($columns as $column){
        /* 画像情報の読み込み */
        if ($column == 'photo' || $column == 'thumbnail'){
            hitsuji_community_photo($ref_community, $column, $community['community']);
        } elseif ($column == 'community'){
            $name = mb_strimwidth($community['community'], 0, 20, '...');
            print ($name);
        } elseif ($column == 'vSmall'){
            $src    = empty($community['v_small'])?  NOPHOTO_VSMALL:$community['v_small'];
            $width  = empty($community['v_width'])?  PHOTO_VSMALL_SIZE:$community['v_width'];
            $height = empty($community['v_height'])? PHOTO_VSMALL_SIZE:$community['v_height'];
            print ('<a href="'.HTTP_ACTION.'community/view/community/'.$ref_community.'/">');
            print ('<img src="'.BASE_URL.$src.'" width="'.$width.'" height="'.$height.'" alt="'.$community['community'].'">');
            print ('</a>');
        } else {
            print ($community[$column]);
        }
        print ($separator);
    }
} // hitsuji_community

/**
 * 写真を表示
 *
 * @access public
 * @param integer   $ref_community
 * @param string    $type
 * @param string    $community
 * @return void
 **/
function hitsuji_community_photo($ref_community, $type, $community)
{
    /* 画像情報の読み込み */
    $photo = RKT_DB::getRow('com_community', $ref_community);

    if ($type == 'photo'){
        $src    = empty($photo['filename'])? NOPHOTO_LARGE:$photo['filename'];
        $width  = empty($photo['width'])?    PHOTO_LARGE_SIZE:$photo['width'];
        $height = empty($photo['height'])?   PHOTO_LARGE_SIZE:$photo['height'];
        $size   = PHOTO_LARGE_SIZE;
    } else {
        $src    = empty($photo['thumbnail'])? NOPHOTO_SMALL:$photo['thumbnail'];
        $width  = empty($photo['t_width'])?   PHOTO_SMALL_SIZE:$photo['t_width'];
        $height = empty($photo['t_height'])?  PHOTO_SMALL_SIZE:$photo['t_height'];
        $size   = PHOTO_SMALL_SIZE;
    }
    $margin = ($size - $height) / 2;

    $title = str_replace('[m:', '[', $community);
    print ('<a href="'.HTTP_ACTION.'community/view/community/'.$ref_community.'/" title="'.$title.'">');
    print ('<img src="'.BASE_URL.$src.'" width="'.$width.'" height="'.$height.'" alt="'.$title.'" style="margin: '.$margin.'px auto;" />');
    print ('</a>');
} // hitsuji_community_photo
?>
