<?php
/* SVN FILE: $Id: blogRecent.php 162 2008-04-23 00:34:48Z bb_yujiro $ */
/**
 * 最近のブログ記事を表示
 *
 * PHP versions 5
 *
 *  Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *  Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 162 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:48 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * 最近のブログ記事
 *
 * @access public
 * @param string $date
 * @param array $info
 * @return void
 **/
function hitsuji_blogRecent($id, $key)
{
    $titles = array(
        'blg_entry'=>     _('Entry List'),
        'blg_comment'=>   _('Comment List'),
        'blg_trackback'=> _('Trackback List'),
    );

    $jsons = array(
        'blg_entry'=>     'member/blog/list/'.$id.'/json/',
        'blg_comment'=>   'member/blog/comments/'.$id.'/0/json/',
        'blg_trackback'=> 'member/blog/trackbacks/'.$id.'/0/json/',
    );

    $icons = array(
        'blg_entry'=>     'book_open.gif',
        'blg_comment'=>   'comment.gif',
        'blg_trackback'=> 'book_olink.gif',
    );
?>
<script type="text/javascript">
blogRecentKey  = '<?php e($key); ?>';
blogRecentUrl  = '<?php e(HTTP_ACTION . $jsons[$key]); ?>';
blogRecentIcon = '<?php e(BASE_URL); ?>resource/img/icons/<?php e($icons[$key]); ?>';
</script>
<script type="text/javascript" src="<?php e(BASE_URL); ?>resource/js/blogRecent.js"></script>
<?php
} // hitsuji_blogRecent
?>
