<?php
/* SVN FILE: $Id: blogCalendar.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * ブログカレンダーを表示
 *
 * PHP versions 5
 *
 *  Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *  Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * ブログカレンダーを表示
 *
 * @access public
 * @param string $date
 * @param array $info
 * @return void
 **/
function hitsuji_blogCalendar($ref_account, $date_pos=1)
{
    $arg_cursor = PATH_INFO_START + $date_pos;
    $path_args  = hitsuji_getPathArg($arg_cursor);

    $timestamp = $path_args[$arg_cursor];
    $firstday  = strtotime(date('Y-m-01', $timestamp));
    $start     = intval(date('w', $firstday));
    $last      = intval(date('t', $timestamp));
    $num_weeks = intval((($start + $last) / 7) + 0.9);
    $year      = date('Y', $timestamp);
    $month     = date('n', $timestamp);
    $day       = 1;
    $format    = date('Y-m-', $timestamp);
    
    $colors    = hitsuji_getColor($year, $month, $start);

    $path_args[$arg_cursor] = strtotime('+2 months -1 day', $firstday);
    $next = HTTP_ACTION. substr(implode('/', $path_args), 1);

    $path_args[$arg_cursor] = strtotime('-1 day', $firstday);
    $prev = HTTP_ACTION. substr(implode('/', $path_args), 1);

    /* 日記 */
    $condition = array(
        'ref_account' => $ref_account,
        'regist_date1'=> array('regist_date', '>=', date('Y-m-01 H:i:s', $timestamp)),
        'regist_date2'=> array('regist_date', '<=', date('Y-m-t H:i:s', $timestamp)),
    );
    $list = RKT_DB::getList('blg_entry', $condition, 'regist_date');
    $entry = array();
    foreach ($list as $row){
        $entry[substr($row['regist_date'], 8, 2)] = true;
    }
?>
						<ul class="horizontal">
							<li style="width:18px; text-align:center;"><a href="<?php e($prev);?>"><img src="<?php e(BASE_URL); ?>resource/img/icons/resultset_previous.gif" width="16" height="16" alt="<<" align="top" /></a></li>
							<li style="width:130px; text-align:center;"><?php echo date(_('Y-m'), $timestamp); ?></li>
							<li style="width:18px; text-align:center;"><a href="<?php e($next);?>"><img src="<?php e(BASE_URL); ?>resource/img/icons/resultset_next.gif" width="16" height="16" alt=">>" align="top" /></a></li>
						</ul><br /><br />
						<table class="calendar" align="center" style="width:170px;" cellpadding="1" cellspacing="0">
							<tr>
								<td class="red"   style="text-align: center;"><?php _e('Sun'); ?></td>
								<td class="white" style="text-align: center;"><?php _e('Mon'); ?></td>
								<td class="white" style="text-align: center;"><?php _e('Tue'); ?></td>
								<td class="white" style="text-align: center;"><?php _e('Wed'); ?></td>
								<td class="white" style="text-align: center;"><?php _e('Thu'); ?></td>
								<td class="white" style="text-align: center;"><?php _e('Fri'); ?></td>
								<td class="blue"  style="text-align: center;"><?php _e('Sat'); ?></td>
							</tr>
<?php for ($row=0; $row<$num_weeks; $row++): ?>
							<tr>
<?php   for ($col=0; $col<$start; $col++): ?><td class="<?php e($colors[$row][$col]);?>" height="12"><br /></td><?php   endfor; ?>
<?php   for ($col=$start; $col<7 && $day<=$last; $col++): ?>
								<td class="<?php e($colors[$row][$col]);?>" style="text-align: center;" height="16">
									<?php hitsuji_day($day, $entry, $ref_account, $format); $day++; ?>
								</td>
<?php   endfor;
        $start = 0; 
?>
<?php   for ($col; $col<7; $col++): ?><td class="<?php e($colors[$row][$col]);?>" height="12"><br /></td><?php   endfor; ?>
							</tr>
<?php endfor; ?>
						</tbody></table>
<?php
} // hitsuji_calendar

/**
 * 日にちを出力
 *
 * @access private
 * @param integer $day
 * @param array $info
 * @return void
 */
function hitsuji_getPathArg($arg_cursor)
{
    $path_info = empty($_SERVER[PATH_INFO_KEY])?'':$_SERVER[PATH_INFO_KEY];
    $path_args = explode('/', $path_info);

    if (empty($path_args[$arg_cursor])){
        $path_args[$arg_cursor] = time();
        $path_args[] = '';
    } else {
        if (!is_numeric($path_args[$arg_cursor])){
            $path_args[$arg_cursor] = time();
        }
    }

    return $path_args;
}

/**
 * 日にちを出力
 *
 * @access private
 * @param integer $day
 * @param array $info
 * @return void
 */
function hitsuji_day($day, $entry, $ref_account, $format)
{
    if (empty($entry[$day])){
        print ($day);
    } else {
        $timestamp = strtotime(sprintf($format.'%02d', $day));
        print ('<a href="'.HTTP_ACTION.'member/blog/list/'.$ref_account.'/'.$timestamp.'/">');
        print ($day);
        print ('</a>');
    }
}

/**
 * 春分／秋分の日を取得する
 *
 * @access private
 * @param array &$h_days
 * @param integer $year
 * @param integer $month
 * @return void
 */
function hitsuji_pushEquinox(&$h_days, $year, $month)
{
    if ($month != 3 && $month != 9){
        return;
    }
    $difference = intval(($year - 1980)/4);
    $const = array(
        3=>20.8431,
        9=>23.2488
    );

    $equinox = (int)($const[$month] + 0.242194*($year - 1980) - $difference);
    array_push($h_days[$month], $equinox);
}
    
/**
 * 指定月の休日／祝日などを2次元配列に格納する
 *
 * @access private
 * @param integer $year
 * @param integer $month
 * @param integer $start
 * @return array
 */
function hitsuji_getColor($year, $month, $start)
{
    $colors = array(
        array('red', 'white', 'white', 'white', 'white', 'white', 'blue'),
        array('red', 'white', 'white', 'white', 'white', 'white', 'blue'),
        array('red', 'white', 'white', 'white', 'white', 'white', 'blue'),
        array('red', 'white', 'white', 'white', 'white', 'white', 'blue'),
        array('red', 'white', 'white', 'white', 'white', 'white', 'blue'),
        array('red', 'white', 'white', 'white', 'white', 'white', 'blue'),
    );

    $h_days = array(
         1=> array(1),          // 元旦
         2=> array(11),         // 建国記念日
         3=> array(),
         4=> array(29),         // みどりの日
         5=> array(3,4,5),      // 憲法記念日,こどもの日
         6=> array(),
         7=> array(),
         8=> array(),
         9=> array(),
        10=> array(),
        11=> array(3,23),       // 文化の日,勤労感謝の日
        12=> array(23)          // 天皇誕生日
    );
    hitsuji_pushEquinox($h_days, $year, $month);
    
    // 固定祝日
    foreach ($h_days[$month] as $h_day){
        $pos  = $start + ($h_day -1);
        $week = intval($pos/7);
        $yobi = $pos - ($week*7);
        $colors[$week][($yobi ? $yobi:1)] = 'red'; // holiday
    }
    
    // ハッピーマンデー
    $mdct = ($start > 1)? 1:0;       // 最初の月曜日が第1週にあるか
    switch ($month){
    case 1:
        $mdct += 1;                        // 第2月曜 成人の日
        $colors[$mdct][1] = 'red';
        break;
    case 7:
        $mdct += 2;                        // 第3月曜 海の日
        $colors[$mdct][1] = 'red';
        break;
    case 9:
        $mdct += 2;                        // 第3月曜 敬老の日
        $colors[$mdct][1] = 'red';
        break;
    case 10:
        $mdct += 1;                        // 第2月曜 体育の日
        $colors[$mdct][1] = 'red';
        break;
    default:
        break;
    }

    return ($colors);
}
?>
