<?php
/* SVN FILE: $Id: viw_event.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * sys_sponsorテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * viw_eventテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_viw_event extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_entry';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'ent.id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_account'=> array(
            'column'=>     'fri.ref_account',
            'key'=>        'ref_account',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_DIRECT,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->field = 'evt.id as id,'.
                       'evt.modified as modified,'.
                       'evt.regist_date as regist_date,'.
                       'evt.ref_community as ref_community,'.
                       'evt.event as event,'.
                       'evt.comment as comment,'.
                       'evt.posts as posts';
        $this->from  = 'FROM '.
                        DB_PREFIX.'com_names nam,'.
                        DB_PREFIX.'com_event evt ';
        $this->where[] = 'nam.ref_community = evt.ref_community';
        $this->where[] = 'nam.status & '.PERMISSION_MEMBERS;
        $this->where[] = 'nam.bulletin = '.STATUS_ENABLE;
    }
} // class viw_event
?>
