<?php
/* SVN FILE: $Id: viw_comment.php 320 2008-05-11 01:02:54Z bb_yujiro $ */
/**
 * sys_sponsorテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 320 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:02:54 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * viw_commentテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 320 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:02:54 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_viw_comment extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'dia_comment';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'com.id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_account'=> array(
            'column'=>     'com.ref_account',
            'key'=>        'ref_account',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_DIRECT,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->field = 'ent.id as id,'.
                       'ent.modified as modified,'.
                       'ent.regist_date as regist_date,'.
                       'ent.ref_account as ref_account,'.
                       'ent.posts as posts,'.
                       'ent.subject as subject,'.
                       'ent.body as body';
        $this->from  = 'FROM '.
                        DB_PREFIX.'blg_comment com,'.
                        DB_PREFIX.'blg_entry ent ';
        $this->where[] = 'com.ref_entry = ent.id';
        $this->group = 'ent.id,'.
                       'ent.modified,'.
                       'ent.regist_date,'.
                       'ent.posts,'.
                       'ent.ref_account,'.
                       'ent.subject,'.
                       'ent.body';
    }
} // class viw_comment
?>
