<?php
/* SVN FILE: $Id: fav_favorite.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * fav_favoriteテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

require_once LIB_DIR.'PEAR/HTML/TagCloud.php';

/**
 * fav_favoriteテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_fav_favorite extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'fav_favorite';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'tag'=> array(
            'column'=>     'tag',
            'key'=>        'tag',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'8000'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripJavaScript'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );
    /* <<<<<end */

    /**
     * タグクラウドの取得
     *
     * @abstract
     * @access public
     * @return array
     */
    public function getTagCloud($ref_account)
    {
        $sql = 'SELECT tag,count(tag) as num FROM '.DB_PREFIX.'fav_tag '.
               'WHERE ref_account = :ref_account GROUP BY tag';
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(array(':ref_account'=> $ref_account));
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
    
        $list_url = HTTP_ACTION.'private/view/favorite/'.US.'tag=';
        $baseFontSize  = 36;
        $fontSizeRange = 24;
        // Tag size range in ($baseFontSize - $fontSizeRange) to
        // ($baseFontSize + $fontSizeRange).
        $tags = new HTML_TagCloud($baseFontSize, $fontSizeRange);
        foreach ($result as $row){
            $tags->addElement($row['tag'], $list_url.urlencode($row['tag']));
        }
        // html part only
        $taghtml = $tags->buildHTML();
        return $taghtml;
    }
} // class fav_favorite
?>
