<?php
/* SVN FILE: $Id: com_event.php 414 2008-05-18 07:49:47Z bb_yujiro $ */
/**
 * com_eventテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 414 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:49:47 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * com_eventテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 414 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-18 16:49:47 +0900 (日, 18 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_com_event extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'com_event';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'start_date'=> array(
            'column'=>     'start_date',
            'key'=>        'start_date',
            'type'=>       'date',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=>'%Y-%n-%d'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'deadline'=> array(
            'column'=>     'deadline',
            'key'=>        'deadline',
            'type'=>       'date',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=>'%Y-%n-%d'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_region'=> array(
            'column'=>     'ref_region',
            'key'=>        'ref_region',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'region',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'keyword'=> array(
            'column'=>     'comment',
            'key'=>        'keyword',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('right'=>true),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  'LIKE',
        ),
        'basing'=> array(
            'column'=>     'start_date',
            'key'=>        'basing',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=> 'Y-m-d H:i:s'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'strToDate'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '>=',
        ),
        'publish'=> array(
            'column'=>     'start_date',
            'key'=>        'publish',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('format'=> 'Y-m-d H:i:s'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'strToDate'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '<=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_region'=> 'ara_region',
    );
    /* <<<<<end */
} // class com_event
?>
