<?php
/* SVN FILE: $Id: act_profile.php 390 2008-05-16 08:19:59Z bb_yujiro $ */
/**
 * act_profileテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 390 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-16 17:19:59 +0900 (金, 16 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_profileテーブルクラス
 *
 * @category        Hitsuji : Model_View 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 390 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-16 17:19:59 +0900 (金, 16 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class View_act_profile extends Model_View 
{
    /* start>>>>> */
    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_profile';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'first_name'=> array(
            'column'=>     'pro.first_name',
            'key'=>        'first_name',
            'type'=>       'string',
            'pdo_type'=>   'PDO::PARAM_LOB',
            'option'=>     CRYPT_OUTPUT_FUNC,
            'required'=>   FALSE,
            'effect'=>     array('RKT_Crypt', 'getEncrypted'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'last_name'=> array(
            'column'=>     'pro.last_name',
            'key'=>        'last_name',
            'type'=>       'string',
            'pdo_type'=>   'PDO::PARAM_LOB',
            'option'=>     CRYPT_OUTPUT_FUNC,
            'required'=>   FALSE,
            'effect'=>     array('RKT_Crypt', 'getEncrypted'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'nickname'=> array(
            'column'=>     'pro.nickname',
            'key'=>        'nickname',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('max_length'=>'128'),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_region'=> array(
            'column'=>     'pro.ref_region',
            'key'=>        'ref_region',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'ara_region',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_city'=> array(
            'column'=>     'pro.ref_city',
            'key'=>        'ref_city',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'ara_city',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_gender'=> array(
            'column'=>     'pro.ref_gender',
            'key'=>        'ref_gender',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'pro_gender',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_blood'=> array(
            'column'=>     'pro.ref_blood',
            'key'=>        'ref_blood',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'pro_blood',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_married'=> array(
            'column'=>     'pro.ref_married',
            'key'=>        'ref_married',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'pro_married',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_hometown'=> array(
            'column'=>     'pro.ref_hometown',
            'key'=>        'ref_hometown',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'ara_region',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'ref_homecity'=> array(
            'column'=>     'pro.ref_homecity',
            'key'=>        'ref_homecity',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'ara_city',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'age_left'=> array(
            'column'=>     'pro.birthday',
            'key'=>        'age_left',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('left'=>true),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'ageToDate'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '>',
        ),
        'age_right'=> array(
            'column'=>     'pro.birthday',
            'key'=>        'age_right',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('right'=>true),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'ageToDate'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '<=',
        ),
        'taste'=> array(
            'column'=>     'pro.taste',
            'key'=>        'taste',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  'taste',
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
        'keyword'=> array(
            'column'=>     'pro.comment',
            'key'=>        'keyword',
            'type'=>       'string',
            'pdo_type'=>   PDO::PARAM_STR,
            'option'=>     array('right'=>true),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  'LIKE',
        ),
        'photo'=> array(
            'column'=>     'pro.photo',
            'key'=>        'photo',
            'type'=>       'number',
            'pdo_type'=>   PDO::PARAM_INT,
            'option'=>     array(),
            'required'=>   FALSE,
            'effect'=>     array('RKT_Request', 'multiStripTags'),
            'reference'=>  FALSE,
            'input'=>      RKT_Model::INPUT_CHATCH,
            'operator'=>  '=',
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_region'=> 'ara_region',
        'ref_gender'=> 'act_gender',
        'ref_blood'=> 'act_blood',
        'ref_married'=> 'act_married',
        'taste'=> 'act_taste',
    );
    /* <<<<<end */

    /**
     * オーダーリスト
     * @var array
     */
    public $order_list = array(
        1=> 'act.last_login DESC',
        2=> 'act.regist_date DESC',
        3=> 'pro.nickname',
    );

    /**
     * オーダーラベルの取得
     *
     * @abstract
     * @access public
     * @return array
     */
    public function getOrderLabel()
    {
        return array(
            1=> _('Last Login'),
            2=> _('Registration'),
            3=> _('Nickname'),
        );
    }

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->field = 'pro.ref_account as ref_account,'.
                       'pro.nickname as nickname,'.
                       'pro.comment as comment ';
        $this->from  = 'FROM '.
                        DB_PREFIX.'act_account act,'.
                        DB_PREFIX.'act_profile pro ';
        $this->where[] = 'act.id = pro.ref_account';
        $this->where[] = 'act.avail = '.STATUS_ENABLE;
        $this->order   = 'act.last_login DESC';
    }
} // class act_profile
?>
