<?php
/* SVN FILE: $Id: sys_design.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * sys_designテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * sys_designテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class sys_design extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_common 
     * @var number 
     */
    public $ref_common = null;

    /**
     * ref_admin 
     * @var number 
     */
    public $ref_admin = null;

    /**
     * ref_private 
     * @var number 
     */
    public $ref_private = null;

    /**
     * ref_friend 
     * @var number 
     */
    public $ref_friend = null;

    /**
     * ref_community 
     * @var number 
     */
    public $ref_community = null;

    /**
     * ref_public 
     * @var number 
     */
    public $ref_public = null;

    /**
     * frame_width 
     * @var number 
     */
    public $frame_width = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'sys_design';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_common'=> array(
            'column'=>    'ref_common',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_admin'=> array(
            'column'=>    'ref_admin',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_private'=> array(
            'column'=>    'ref_private',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_friend'=> array(
            'column'=>    'ref_friend',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_community'=> array(
            'column'=>    'ref_community',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_public'=> array(
            'column'=>    'ref_public',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'frame_width'=> array(
            'column'=>    'frame_width',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_common,ref_admin,ref_private,ref_friend,ref_community,ref_public,frame_width';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_common,:ref_admin,:ref_private,:ref_friend,:ref_community,:ref_public,:frame_width';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_common=:ref_common, ref_admin=:ref_admin, ref_private=:ref_private, ref_friend=:ref_friend, ref_community=:ref_community, ref_public=:ref_public, frame_width=:frame_width';
    /* <<<<<end */
} // class sys_design
?>
