<?php
/* SVN FILE: $Id: sum_answer.php 377 2008-05-15 02:35:21Z bb_yujiro $ */
/**
 * sum_answerテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * sum_answerテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class sum_answer extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_poll 
     * @var number 
     */
    public $ref_poll = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * answer 
     * @var number 
     */
    public $answer = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'sum_answer';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_poll'=> array(
            'column'=>    'ref_poll',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'sum_poll',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'answer'=> array(
            'column'=>    'answer',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_poll,ref_account,answer';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_poll,:ref_account,:answer';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_poll=:ref_poll, ref_account=:ref_account, answer=:answer';
    /* <<<<<end */

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        include MODEL_DIR.'manips'.DS.'sum_poll.php';
        $objpol = new sum_poll();

        $objpol->setCurId($this->ref_topic);
        $objpol->setInitValue();

        $condition = array(
            'ref_topic'=> $this->ref_topic
        );
        $row = RKT_DB::getRow($this->tbl_name, $condition, 'count(*) as ct');

        $objpol->setValue('posts',  $row['ct']);
        $objpol->manip();
    }
} // class sum_answer
?>
