<?php
/* SVN FILE: $Id: com_community.php 377 2008-05-15 02:35:21Z bb_yujiro $ */
/**
 * com_communityテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * com_communityテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class com_community extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * avail 
     * @var number 
     */
    public $avail = null;

    /**
     * community 
     * @var string 
     */
    public $community = null;

    /**
     * ref_category 
     * @var number 
     */
    public $ref_category = null;

    /**
     * visibility 
     * @var number 
     */
    public $visibility = null;

    /**
     * involved 
     * @var number 
     */
    public $involved = null;

    /**
     * topic_flag 
     * @var number 
     */
    public $topic_flag = null;

    /**
     * event_flag 
     * @var number 
     */
    public $event_flag = null;

    /**
     * article_flag 
     * @var number 
     */
    public $article_flag = null;

    /**
     * ref_region 
     * @var number 
     */
    public $ref_region = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * member_num 
     * @var number 
     */
    public $member_num = null;

    /**
     * access_num 
     * @var number 
     */
    public $access_num = null;

    /**
     * filename 
     * @var string 
     */
    public $filename = null;

    /**
     * width 
     * @var number 
     */
    public $width = null;

    /**
     * height 
     * @var number 
     */
    public $height = null;

    /**
     * thumbnail 
     * @var string 
     */
    public $thumbnail = null;

    /**
     * t_width 
     * @var number 
     */
    public $t_width = null;

    /**
     * t_height 
     * @var number 
     */
    public $t_height = null;

    /**
     * v_small 
     * @var string 
     */
    public $v_small = null;

    /**
     * v_width 
     * @var number 
     */
    public $v_width = null;

    /**
     * v_height 
     * @var number 
     */
    public $v_height = null;

    /**
     * ref_theme 
     * @var number 
     */
    public $ref_theme = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'com_community';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'avail'=> array(
            'column'=>    'avail',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'community'=> array(
            'column'=>    'community',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_category'=> array(
            'column'=>    'ref_category',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'com_category',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'visibility'=> array(
            'column'=>    'visibility',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'involved'=> array(
            'column'=>    'involved',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'topic_flag'=> array(
            'column'=>    'topic_flag',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'event_flag'=> array(
            'column'=>    'event_flag',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'article_flag'=> array(
            'column'=>    'article_flag',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_region'=> array(
            'column'=>    'ref_region',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'member_num'=> array(
            'column'=>    'member_num',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'access_num'=> array(
            'column'=>    'access_num',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'filename'=> array(
            'column'=>    'filename',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'width'=> array(
            'column'=>    'width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'height'=> array(
            'column'=>    'height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'thumbnail'=> array(
            'column'=>    'thumbnail',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        't_width'=> array(
            'column'=>    't_width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        't_height'=> array(
            'column'=>    't_height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_small'=> array(
            'column'=>    'v_small',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_width'=> array(
            'column'=>    'v_width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_height'=> array(
            'column'=>    'v_height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_theme'=> array(
            'column'=>    'ref_theme',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_category'=> 'com_category',
        'ref_region'=> 'ara_region',
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,ref_account,avail,community,ref_category,visibility,involved,topic_flag,event_flag,article_flag,ref_region,comment,member_num,access_num,filename,width,height,thumbnail,t_width,t_height,v_small,v_width,v_height,ref_theme';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:ref_account,:avail,:community,:ref_category,:visibility,:involved,:topic_flag,:event_flag,:article_flag,:ref_region,:comment,:member_num,:access_num,:filename,:width,:height,:thumbnail,:t_width,:t_height,:v_small,:v_width,:v_height,:ref_theme';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, ref_account=:ref_account, avail=:avail, community=:community, ref_category=:ref_category, visibility=:visibility, involved=:involved, topic_flag=:topic_flag, event_flag=:event_flag, article_flag=:article_flag, ref_region=:ref_region, comment=:comment, member_num=:member_num, access_num=:access_num, filename=:filename, width=:width, height=:height, thumbnail=:thumbnail, t_width=:t_width, t_height=:t_height, v_small=:v_small, v_width=:v_width, v_height=:v_height, ref_theme=:ref_theme';
    /* <<<<<end */

    /**
     * ファイル名 
     * @var string 
     */
    public $name = null;

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            $this->_deleteCommunity();
        } elseif ($this->action_flag != RKT_Model::QUERY_INSERT){
            return ;
        }

        include MODEL_DIR.'manips'.DS.'com_names.php';
        $objnam = new com_names();

        $objnam->setInitValue();

        $objnam->setValue('ref_community', $this->cur_id);
        $objnam->setValue('ref_account',   $this->ref_account);
        $objnam->setValue('status',        PERMISSION_LEADER);
        $objnam->setValue('visibility',    VISIBILITY_PUBLIC);
        $objnam->setValue('bulletin',      STATUS_ENABLE);

        $objnam->manip();
    }

    /**
     * 画像の削除
     *
     * @access public
     * @return boolean 成功時真
     */
    public function deletePhoto()
    {
        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_Blob::getInstance();

        $objblb->unlink($this->filename);
        $objblb->unlink($this->thumbnail);
        $objblb->unlink($this->v_small);

        $this->filename = '';
        $this->width    = 0;
        $this->height   = 0;

        $this->thumbnail = '';
        $this->t_width   = 0;
        $this->t_height  = 0;

        $this->v_small  = '';
        $this->v_width  = 0;
        $this->v_height = 0;
        
        $this->setUpdate();
    }

    /**
     * 選択された画像ファイルをリサイズする
     *
     * @access public
     * @return boolean
     */
    public function selectedPhoto($filename)
    {
        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_Blob::getInstance();

        if (!$objblb->load($filename)){
            return false;
        }
        $mime_type = $objblb->getMimeType();
        if (!preg_match('/image/i', $mime_type)){
            return false;
        }
        
        include_once LIB_DIR.'rkt_image.php';
        $objimg = RKT_Image::getInstance();

        $binary = $objblb->getBuffer();
        $format = $objblb->getExtension();
        $objimg->setBinary($binary, $format);

        /* 大きいサイズの画像 */
        $objimg->resize(PHOTO_LARGE_SIZE, PHOTO_LARGE_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->cur_id.'/large/'.$name.'.'.$format;
        $objblb->save($filename);
        $this->filename = $filename;
        $this->width    = $infos['width'];
        $this->height   = $infos['height'];

        /* 小さいサイズの画像 */
        $objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->cur_id.'/small/'.$name.'.'.$format;
        $objblb->save($filename);
        $this->thumbnail = $filename;
        $this->t_width   = $infos['width'];
        $this->t_height  = $infos['height'];

        /* さらに小さいサイズの画像 */
        $objimg->resize(PHOTO_VSMALL_SIZE, PHOTO_VSMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->cur_id.'/vsmall/'.$name.'.'.$format;
        $objblb->save($filename);
        $this->v_small  = $filename;
        $this->v_width  = $infos['width'];
        $this->v_height = $infos['height'];

        return true;
    }

    /**
     * アップロードされた情報をメンバ変数へセットする
     *
     * @access public
     * @param string $key
     * @return boolean 成功時真
     */
    public function catchFile($key)
    {
        if (!isSet($_FILES[$key])) {
            return false;
        }
        if ($_FILES[$key]['error'] != UPLOAD_ERR_OK) {
            return false;
        }
        /* ファイルの種類が画像か判定 */
        if (!preg_match('/image/i', $_FILES[$key]['type'])){
            return false;
        }

        $this->filename  = $_FILES[$key]['tmp_name'];
        $this->name      = $_FILES[$key]['name'];
        $this->_saveResize();

        return true;
    }

    /**
     * アップされた画像ファイルをリサイズする
     *
     * @access public
     * @return void
     */
    private function _saveResize()
    {
        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        include_once LIB_DIR.'rkt_blob.php';
        include_once LIB_DIR.'rkt_image.php';
        $objblb = RKT_Blob::getInstance();
        $objimg = RKT_Image::getInstance();
        
        $objimg->readImage($this->filename);
        $objblb->setUID($this->ref_account);
        $objblb->setGID($this->cur_id);
        $extension = $objblb->getExtension($this->name);

        /* 大きいサイズの画像 */
        $objimg->resize(PHOTO_LARGE_SIZE, PHOTO_LARGE_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->cur_id.'/large/'.$name.'.'.$extension;
        $objblb->save($filename);
        $this->filename = $filename;
        $this->width    = $infos['width'];
        $this->height   = $infos['height'];

        /* 小さいサイズの画像 */
        $objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->cur_id.'/small/'.$name.'.'.$extension;
        $objblb->save($filename);
        $this->thumbnail = $filename;
        $this->t_width   = $infos['width'];
        $this->t_height  = $infos['height'];

        /* さらに小さいサイズの画像 */
        $objimg->resize(PHOTO_VSMALL_SIZE, PHOTO_VSMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_COMMUNITY_PATH.$this->cur_id.'/vsmall/'.$name.'.'.$extension;
        $objblb->save($filename);
        $this->v_small  = $filename;
        $this->v_width  = $infos['width'];
        $this->v_height = $infos['height'];
    }

    /**
     * コミュニティ削除
     *
     * @access private
     */
    private function _deleteCommunity()
    {
        /* 記事削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_article '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* イベント参加削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_attend '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* フォーラムコメント削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_comment '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* イベント削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_event '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* 名簿削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_names '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* イベントレポート削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_report '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* トピック削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_topic '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* トラックバック削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_trackback '.
               'WHERE ref_community = '.$this->cur_id;
        $this->objdb->exec($sql);

        /* コミュニティ画像の削除 */
        include_once LIB_DIR.'rkt_blob.php';
        $objblb = RKT_Blob::getInstance();

        $objblb->unlink($this->filename);
        $objblb->unlink($this->thumbnail);
        $objblb->unlink($this->v_small);
    }
} // class com_community
?>
