<?php
/* SVN FILE: $Id: com_category.php 292 2008-05-09 00:08:10Z bb_yujiro $ */
/**
 * com_categoryテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 292 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:10 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * com_categoryテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 292 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-09 09:08:10 +0900 (金, 09 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class com_category extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_genre 
     * @var number 
     */
    public $ref_genre = null;

    /**
     * sort 
     * @var number 
     */
    public $sort = null;

    /**
     * category 
     * @var string 
     */
    public $category = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'com_category';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_genre'=> array(
            'column'=>    'ref_genre',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'com_genre',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'sort'=> array(
            'column'=>    'sort',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'category'=> array(
            'column'=>    'category',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_genre'=> 'com_genre',
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_genre,sort,category';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_genre,:sort,:category';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_genre=:ref_genre, sort=:sort, category=:category';
    /* <<<<<end */

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_INSERT){
            $condition = array(
                'ref_genre'=> $this->ref_genre
            );
            $max  = RKT_DB::getRow($this->tbl_name, $condition, 'max(sort) as mx');
            $this->sort = empty($max['mx'])? 1:$max['mx']+1;
        }
    }
} // class com_category
?>
