<?php
/* SVN FILE: $Id: cnt_contact.php 506 2008-05-25 13:01:21Z bb_yujiro $ */
/**
 * cnt_contactテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 506 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 22:01:21 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * cnt_contactテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 506 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 22:01:21 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class cnt_contact extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * ref_category 
     * @var number 
     */
    public $ref_category = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * flag 
     * @var number 
     */
    public $flag = null;

    /**
     * name 
     * @var string 
     */
    public $name = null;

    /**
     * url 
     * @var uri 
     */
    public $url = null;

    /**
     * email 
     * @var email 
     */
    public $email = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'cnt_contact';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '0000-00-00 00:00:00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_category'=> array(
            'column'=>    'ref_category',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'cnt_category',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'flag'=> array(
            'column'=>    'flag',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'name'=> array(
            'column'=>    'name',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'url'=> array(
            'column'=>    'url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'email'=> array(
            'column'=>    'email',
            'type'=>      'email',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_LOB,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_category'=> 'cnt_category',
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,ref_category,ref_account,status,flag,name,url,email,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:ref_category,:ref_account,:status,:flag,:name,:url,:email,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, ref_category=:ref_category, ref_account=:ref_account, status=:status, flag=:flag, name=:name, url=:url, email=:email, comment=:comment';
    /* <<<<<end */

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag !== RKT_Model::QUERY_INSERT){
            return ;
        }

        $email = RKT_Crypt::getEncrypted($this->email);
        $this->setValue('email', $email);
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        $this->_sendMail();
    }

    /**
     * 確認メール送信
     *
     * @access public
     */
    protected function _sendMail()
    {
        if ($this->action_flag !== RKT_Model::QUERY_INSERT){
            return ;
        }

        include_once LIB_DIR.'rkt_message.php';
        $objsnd = RKT_Message::getInstance('contact');
        $email  = RKT_Crypt::getDecrypted($this->email);

        $objsnd->Assign('user_name', $this->name);
        $objsnd->Assign('email',     $email);
        $objsnd->Assign('comment',   $this->comment."\r\n");
        $objsnd->send($email);
    }

} // class cnt_contact
?>
