<?php
/* SVN FILE: $Id: cal_comment.php 320 2008-05-11 01:02:54Z bb_yujiro $ */
/**
 * cal_commentテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 320 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:02:54 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * cal_commentテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 320 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 10:02:54 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class cal_comment extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_schedule 
     * @var number 
     */
    public $ref_schedule = null;

    /**
     * ref_author 
     * @var number 
     */
    public $ref_author = null;

    /**
     * flag 
     * @var number 
     */
    public $flag = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'cal_comment';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_schedule'=> array(
            'column'=>    'ref_schedule',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'cal_schedule',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_author'=> array(
            'column'=>    'ref_author',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'flag'=> array(
            'column'=>    'flag',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,ref_account,ref_schedule,ref_author,flag,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:ref_account,:ref_schedule,:ref_author,:flag,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, ref_account=:ref_account, ref_schedule=:ref_schedule, ref_author=:ref_author, flag=:flag, comment=:comment';
    /* <<<<<end */

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        include MODEL_DIR.'manips'.DS.'cal_schedule.php';
        $objsch = new cal_schedule();

        $objsch->setCurId($this->ref_schedule);
        $objsch->setInitValue();

        $condition = array(
            'ref_schedule'=> $this->ref_schedule
        );
        $row = RKT_DB::getRow($this->tbl_name, $condition, 'count(*) as ct');

        $objsch->setValue('posts',  $row['ct']);
        $objsch->manip();
    }
} // class cal_comment
?>
