<?php
/* SVN FILE: $Id: blg_tag.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * blg_tagテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * blg_tagテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class blg_tag extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_entry 
     * @var number 
     */
    public $ref_entry = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * tag 
     * @var string 
     */
    public $tag = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_tag';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_entry'=> array(
            'column'=>    'ref_entry',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'blg_entry',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'tag'=> array(
            'column'=>    'tag',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_entry,ref_account,tag';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_entry,:ref_account,:tag';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_entry=:ref_entry, ref_account=:ref_account, tag=:tag';
    /* <<<<<end */

    /**
     * タグ一覧
     * @var array 
     */
    private $_tags = null;

    /**
     * 更新リストの処理
     *
     * @access public
     * @return void
     **/
    public function manipTags($tags)
    {
        if (empty($tags)){
            return ;
        }
        $this->_setTags();

        $modified = date('Y-m-d H:i:s');
        $tags = $this->_splitTags($tags);

        foreach ($tags as $tag){
            if (empty($this->_tags[$tag])){
                $this->setInsert();
            } else {
                $this->setCurId($this->_tags[$tag]);
                $this->setUpdate();
                unset($this->_tags[$tag]);
            }
            $this->setValue('modified',    $modified);
            $this->setValue('ref_entry',   $this->ref_entry);
            $this->setValue('ref_account', $this->ref_account);
            $this->setValue('tag',         $tag);
            $this->manip();
        }

        if (empty($this->_tags)){
            return ;
        }
        /* 入力されないタグを削除 */
        foreach ($this->_tags as $id){
            $this->setCurId($id);
            $this->setDelete();
            $this->manip();
        }
    }

    /**
     * タグの分割
     *
     * @access private
     * @return void
     */
    private function _splitTags($tags)
    {
        $tags = str_replace('　', ' ', $tags);
        return explode(' ', $tags);
    }

    /**
     * データベースから取得
     *
     * @access private
     * @return void
     */
    private function _setTags()
    {
        $condition = array(
            'ref_entry'=>   $this->ref_entry,
            'ref_account'=> $this->ref_account,
        );
        $result = RKT_DB::getList($this->tbl_name, $condition);
        foreach ($result as $row){
            $this->_tags[$row['tag']] = $row['id'];
        }
    }
} // class blg_tag
?>
