<?php
/* SVN FILE: $Id: blg_sendtb.php 345 2008-05-11 03:01:06Z bb_yujiro $ */
/**
 * blg_sendtbテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 345 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 12:01:06 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * blg_sendtbテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 345 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-11 12:01:06 +0900 (日, 11 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class blg_sendtb extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_entry 
     * @var number 
     */
    public $ref_entry = null;

    /**
     * status 
     * @var number 
     */
    public $status = null;

    /**
     * url 
     * @var uri 
     */
    public $url = null;

    /**
     * hashed_url 
     * @var uri 
     */
    public $hashed_url = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_sendtb';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_entry'=> array(
            'column'=>    'ref_entry',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'blg_entry',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'status'=> array(
            'column'=>    'status',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'url'=> array(
            'column'=>    'url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'hashed_url'=> array(
            'column'=>    'hashed_url',
            'type'=>      'uri',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'64'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_account,ref_entry,status,url,hashed_url';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_account,:ref_entry,:status,:url,:hashed_url';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_account=:ref_account, ref_entry=:ref_entry, status=:status, url=:url, hashed_url=:hashed_url';
    /* <<<<<end */

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        if ($this->action_flag != RKT_Model::QUERY_INSERT){
            return ;
        }
        register_shutdown_function(array($this, 'sendTrackback'));
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    public function sendTrackback()
    {
        include LIB_DIR.'PEAR/Services/Trackback.php';

        $entry = RKT_DB::getRow('blg_entry', $this->ref_entry);

        // Services_Trackbackオブジェクトの生成
        $trackback = new Services_Trackback();
 
        // 各送信トラックバック情報を設定
        $trackback->set('title',         $entry['subject']);
        $trackback->set('url',           HTTP_ACTION.'member/blog/view/'.$this->ref_entry.'/');
        $trackback->set('excerpt',       $entry['body']);
        $trackback->set('blog_name',     SNS_NAME);
        $trackback->set('trackback_url', $this->url);

        $cookie = array(
            'name'=>  session_name(),
            'value'=> session_id(),
        );

        $result = $trackback->send(null, $cookie);
    }

} // class blg_sendtb
?>
