<?php
/* SVN FILE: $Id: blg_comment.php 428 2008-05-19 11:32:28Z bb_yujiro $ */
/**
 * blg_commentテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 428 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-19 20:32:28 +0900 (月, 19 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * blg_commentテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 428 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-19 20:32:28 +0900 (月, 19 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class blg_comment extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * regist_date 
     * @var date 
     */
    public $regist_date = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_entry 
     * @var number 
     */
    public $ref_entry = null;

    /**
     * ref_author 
     * @var number 
     */
    public $ref_author = null;

    /**
     * flag 
     * @var number 
     */
    public $flag = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'blg_comment';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'regist_date'=> array(
            'column'=>    'regist_date',
            'type'=>      'date',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_entry'=> array(
            'column'=>    'ref_entry',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'blg_entry',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_author'=> array(
            'column'=>    'ref_author',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'flag'=> array(
            'column'=>    'flag',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,regist_date,ref_account,ref_entry,ref_author,flag,comment';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:regist_date,:ref_account,:ref_entry,:ref_author,:flag,:comment';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, regist_date=:regist_date, ref_account=:ref_account, ref_entry=:ref_entry, ref_author=:ref_author, flag=:flag, comment=:comment';
    /* <<<<<end */

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        include MODEL_DIR.'manips'.DS.'blg_entry.php';
        $objent = new blg_entry();

        $objent->setCurId($this->ref_entry);
        $objent->setInitValue();

        /* プロフィール読み込み */
        $condition = array(
            'ref_entry'=> $this->ref_entry
        );
        $row = RKT_DB::getRow('blg_comment', $condition, 'count(*) as ct');

        $objent->setValue('posts',  $row['ct']);
        $objent->manip();
    }

    /**
     * 既読コメント
     *
     * @access public
     */
    public function readComment()
    {
        register_shutdown_function(array($this, 'readFlagComment'));
    }

    /**
     * 既読コメント設定
     *
     * @access public
     */
    public function readFlagComment()
    {
        /* コメントの既読設定 */
        $sql = 'UPDATE '.DB_PREFIX.$this->tbl_name.' '.
                   'SET flag = '.FLAG_READ.' '.
               'WHERE ref_entry = '.$this->ref_entry.' AND '.
                   'ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }
} // class blg_comment
?>
