<?php
/* SVN FILE: $Id: ara_prefecture.php 197 2008-04-29 07:23:59Z bb_yujiro $ */
/**
 * ara_regionテーブルクラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        hitSuji model
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 197 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-29 16:23:59 +0900 (火, 29 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * ara_regionテーブルクラス
 *
 * @category        hitSuji model
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 197 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-29 16:23:59 +0900 (火, 29 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class ara_region extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_area 
     * @var number 
     */
    public $ref_area = null;

    /**
     * sort 
     * @var number 
     */
    public $sort = null;

    /**
     * region 
     * @var string 
     */
    public $region = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'ara_region';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_area'=> array(
            'column'=>    'ref_area',
            'type'=>      'number',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'sns_ara_area',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'sort'=> array(
            'column'=>    'sort',
            'type'=>      'number',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'region'=> array(
            'column'=>    'region',
            'type'=>      'string',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'16'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_area'=> 'sns_ara_area',
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_area,sort,region';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_area,:sort,:region';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_area=:ref_area, sort=:sort, region=:region';
    /* <<<<<end */
} // class ara_region
?>
