<?php
/* SVN FILE: $Id: ara_area.php 197 2008-04-29 07:23:59Z bb_yujiro $ */
/**
 * ara_areaテーブルクラス
 *
 * PHP versions 5
 *
 *      hitSuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @category        hitSuji model
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 197 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-29 16:23:59 +0900 (火, 29 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * ara_areaテーブルクラス
 *
 * @category        hitSuji model
 * @package         hitSuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 197 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-29 16:23:59 +0900 (火, 29 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class ara_area extends Model_Manip 
{
    /* start>>>>> */
    /**
     * sort 
     * @var number 
     */
    public $sort = null;

    /**
     * area 
     * @var string 
     */
    public $area = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'ara_area';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'sort'=> array(
            'column'=>    'sort',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'area'=> array(
            'column'=>    'area',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'32'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'sort,area';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':sort,:area';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'sort=:sort, area=:area';
    /* <<<<<end */
} // class ara_area
?>
