<?php
/* SVN FILE: $Id: act_profile.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * act_profileテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_profileテーブルクラス
 *
 * @category        Hitsuji : model
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_profile extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * first_name 
     * @var string 
     */
    public $first_name = null;

    /**
     * last_name 
     * @var string 
     */
    public $last_name = null;

    /**
     * name_flag 
     * @var number 
     */
    public $name_flag = null;

    /**
     * nickname 
     * @var string 
     */
    public $nickname = null;

    /**
     * visibility 
     * @var number 
     */
    public $visibility = null;

    /**
     * ref_region 
     * @var number 
     */
    public $ref_region = null;

    /**
     * ref_city 
     * @var number 
     */
    public $ref_city = null;

    /**
     * region_flag 
     * @var number 
     */
    public $region_flag = null;

    /**
     * ref_gender 
     * @var number 
     */
    public $ref_gender = null;

    /**
     * gender_flag 
     * @var number 
     */
    public $gender_flag = null;

    /**
     * ref_blood 
     * @var number 
     */
    public $ref_blood = null;

    /**
     * blood_flag 
     * @var number 
     */
    public $blood_flag = null;

    /**
     * birthday 
     * @var date 
     */
    public $birthday = null;

    /**
     * birthday_flag 
     * @var number 
     */
    public $birthday_flag = null;

    /**
     * age_flag 
     * @var number 
     */
    public $age_flag = null;

    /**
     * ref_married 
     * @var number 
     */
    public $ref_married = null;

    /**
     * married_flag 
     * @var number 
     */
    public $married_flag = null;

    /**
     * ref_hometown 
     * @var number 
     */
    public $ref_hometown = null;

    /**
     * ref_homecity 
     * @var number 
     */
    public $ref_homecity = null;

    /**
     * hometown_flag 
     * @var number 
     */
    public $hometown_flag = null;

    /**
     * photo 
     * @var number 
     */
    public $photo = null;

    /**
     * comment 
     * @var string 
     */
    public $comment = null;

    /**
     * taste 
     * @var string 
     */
    public $taste = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_profile';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'first_name'=> array(
            'column'=>    'first_name',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_LOB,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'last_name'=> array(
            'column'=>    'last_name',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_LOB,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'name_flag'=> array(
            'column'=>    'name_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'nickname'=> array(
            'column'=>    'nickname',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'128'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'visibility'=> array(
            'column'=>    'visibility',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_region'=> array(
            'column'=>    'ref_region',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'ara_region',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_city'=> array(
            'column'=>    'ref_city',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'ara_city',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'region_flag'=> array(
            'column'=>    'region_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_gender'=> array(
            'column'=>    'ref_gender',
            'type'=>      'number',
            'default'=>   '3',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_gender',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'gender_flag'=> array(
            'column'=>    'gender_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_blood'=> array(
            'column'=>    'ref_blood',
            'type'=>      'number',
            'default'=>   '5',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_blood',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'blood_flag'=> array(
            'column'=>    'blood_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'birthday'=> array(
            'column'=>    'birthday',
            'type'=>      'date',
            'default'=>   '0000-00-00',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'birthday_flag'=> array(
            'column'=>    'birthday_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'age_flag'=> array(
            'column'=>    'age_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_married'=> array(
            'column'=>    'ref_married',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_married',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'married_flag'=> array(
            'column'=>    'married_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_hometown'=> array(
            'column'=>    'ref_hometown',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'ara_region',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'ref_homecity'=> array(
            'column'=>    'ref_homecity',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'ara_city',
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'hometown_flag'=> array(
            'column'=>    'hometown_flag',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'photo'=> array(
            'column'=>    'photo',
            'type'=>      'photo',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'comment'=> array(
            'column'=>    'comment',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'htmlBody'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'taste'=> array(
            'column'=>    'taste',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
        'ref_region'=> 'ara_region',
        'ref_gender'=> 'act_gender',
        'ref_blood'=> 'act_blood',
        'ref_married'=> 'act_married',
        'taste'=> 'act_taste',
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_account,modified,first_name,last_name,name_flag,nickname,visibility,ref_region,ref_city,region_flag,ref_gender,gender_flag,ref_blood,blood_flag,birthday,birthday_flag,age_flag,ref_married,married_flag,ref_hometown,ref_homecity,hometown_flag,photo,comment,taste';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_account,:modified,:first_name,:last_name,:name_flag,:nickname,:visibility,:ref_region,:ref_city,:region_flag,:ref_gender,:gender_flag,:ref_blood,:blood_flag,:birthday,:birthday_flag,:age_flag,:ref_married,:married_flag,:ref_hometown,:ref_homecity,:hometown_flag,:photo,:comment,:taste';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_account=:ref_account, modified=:modified, first_name=:first_name, last_name=:last_name, name_flag=:name_flag, nickname=:nickname, visibility=:visibility, ref_region=:ref_region, ref_city=:ref_city, region_flag=:region_flag, ref_gender=:ref_gender, gender_flag=:gender_flag, ref_blood=:ref_blood, blood_flag=:blood_flag, birthday=:birthday, birthday_flag=:birthday_flag, age_flag=:age_flag, ref_married=:ref_married, married_flag=:married_flag, ref_hometown=:ref_hometown, ref_homecity=:ref_homecity, hometown_flag=:hometown_flag, photo=:photo, comment=:comment, taste=:taste';
    /* <<<<<end */

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }

        $first_name = empty($this->old_values['first_name'])? '':$this->old_values['first_name'];
        if ($this->first_name != $first_name){
            $crypted = RKT_Crypt::getEncrypted($this->first_name);
            $this->setValue('first_name', $crypted);
        }

        $last_name = empty($this->old_values['last_name'])? '':$this->old_values['last_name'];
        if ($this->last_name != $last_name){
            $crypted = RKT_Crypt::getEncrypted($this->last_name);
            $this->setValue('last_name', $crypted);
        }

        if (is_array($this->taste)){
            $this->setValue('taste', implode(',', $this->taste));
        }
    }

    /**
     * 初期値データへの加工処理
     *
     * @access public
     * @retrun void
     */
    public function initEffect()
    {
        $first_name = RKT_Crypt::getDecrypted($this->old_values['first_name']);
        $last_name  = RKT_Crypt::getDecrypted($this->old_values['last_name']);

        $this->setValue('first_name', $first_name);
        $this->setValue('last_name',  $last_name);
    }
} // class act_profile
?>
