<?php
/* SVN FILE: $Id: act_personality.php 505 2008-05-25 13:00:34Z bb_yujiro $ */
/**
 * act_personalityテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 505 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 22:00:34 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_personalityテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 505 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-25 22:00:34 +0900 (日, 25 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_personality extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_item 
     * @var number 
     */
    public $ref_item = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * visibility 
     * @var number 
     */
    public $visibility = null;

    /**
     * personal 
     * @var string 
     */
    public $personal = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_personality';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_item'=> array(
            'column'=>    'ref_item',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_item',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'visibility'=> array(
            'column'=>    'visibility',
            'type'=>      'number',
            'default'=>   '2',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'personal'=> array(
            'column'=>    'personal',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_item,ref_account,visibility,personal';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_item,:ref_account,:visibility,:personal';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_item=:ref_item, ref_account=:ref_account, visibility=:visibility, personal=:personal';
    /* <<<<<end */

    /**
     * _personality 
     * @var array 
     */
    private $_personality = null;

    /**
     * _personality 
     * @var array 
     */
    private $_personals = null;

    /**
     * 追加項目の設定
     *
     * @access public
     * @return void
     */
    public function getPersonality()
    {
        $this->_catchRequest();
        $result = RKT_DB::getList('act_item', null, '*', 'sort');

        foreach ($result as $row){
            $condition = array(
                'ref_item'=>    $row['id'],
                'ref_account'=> $this->ref_account,
            );
            $personal = $this->_personals[$row['id']];

            $row['ref_item']   = $row['id'];
            $row['visibility'] = isSet($personal['visibility'])? $personal['visibility']:null;
            $row['personal']   = isSet($personal['personal'])?   $personal['personal']:null;
            $row['answers']    = explode("\r\n", $row['answers']);
            
            /* 必須設定 */
            if ($row['required'] == STATUS_ENABLE && !empty($_POST['confirm'])){
                if (empty($row['personal'])){
                    $row['alert'] = true;
                    $this->objrqt->setAlert('personals');
                }
            }
                        
            $this->_personality[] = $row;
        }
        return $this->_personality;
    }

    /**
     * 更新リストの処理
     *
     * @access public
     * @return void
     **/
    public function manipPersonalities()
    {
        if (empty($_POST['manip'])){
            return ;
        }

        $this->_catchRequest();
        if (empty($this->_personals)){
            return ;
        }

        foreach ($this->_personals as $row){
            $condition = array(
                'ref_item'=>    $row['ref_item'],
                'ref_account'=> $this->ref_account,
            );
            $result = RKT_DB::getRow($this->tbl_name, $condition);

            if (empty($result['id'])){
                $this->setInsert();
            } else {
                $this->setCurId($result['id']);
                $this->setUpdate();
            }
            $this->setValue('ref_item',    $row['ref_item']);
            $this->setValue('ref_account', $this->ref_account);
            $this->setValue('visibility',  $row['visibility']);
            $this->setValue('personal',    $row['personal']);
            $this->manip();
        }
    }

    /**
     * リクエストから取得
     *
     * @access private
     * @return void
     */
    private function _catchRequest()
    {
        $this->objrqt->setRequestType('_POST');
        $condition = array (
            'type'=>     'string',
            'option'=>   array(),
            'required'=> true,
        );
        if (!$this->objrqt->catchValidate('personals', $condition)){
            $this->_setPersonality();
            return ;
        }
        $this->_personals = $this->objrqt->getRequest('personals');
    }

    /**
     * データベースから取得
     *
     * @access private
     * @return void
     */
    private function _setPersonality()
    {
        $condition = array(
            'ref_account'=> $this->ref_account,
        );
        $result = RKT_DB::getList($this->tbl_name, $condition);
        foreach ($result as $row){
            $this->_personals[$row['ref_item']] = $row;
        }
    }
} // class act_personality
?>
