<?php
/* SVN FILE: $Id: act_mobile.php 161 2008-04-23 00:34:29Z bb_yujiro $ */
/**
 * act_mobileテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_mobileテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 161 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-04-23 09:34:29 +0900 (水, 23 4 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_mobile extends Model_Manip 
{
    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * email 
     * @var email 
     */
    public $email = null;

    /**
     * hashed_email 
     * @var email 
     */
    public $hashed_email = null;

    /**
     * loginkey 
     * @var string 
     */
    public $loginkey = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_mobile';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'email'=> array(
            'column'=>    'email',
            'type'=>      'email',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_LOB,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'hashed_email'=> array(
            'column'=>    'hashed_email',
            'type'=>      'email',
            'default'=>   NULL,
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'32'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'loginkey'=> array(
            'column'=>    'loginkey',
            'type'=>      'string',
            'default'=>   NULL,
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'32'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_account,email,hashed_email,loginkey';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_account,:email,:hashed_email,:loginkey';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_account=:ref_account, email=:email, hashed_email=:hashed_email, loginkey=:loginkey';
    /* <<<<<end */

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }

        if ($this->email != $this->old_values['email']){
            $this->hashed_email = RKT_Crypt::getHashed($this->email);
            $this->email        = RKT_Crypt::getEncrypted($this->email);
        }

        if (empty($this->loginkey)){
            if (empty($this->old_values['loginkey'])){
                $this->loginkey = null;
            } else {
                $this->loginkey = $this->old_values['loginkey'];
            }
        }
    }
} // class act_mobile
?>
