<?php
/* SVN FILE: $Id: act_item.php 281 2008-05-07 22:23:36Z bb_yujiro $ */
/**
 * act_itemテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_itemテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 281 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-08 07:23:36 +0900 (木, 08 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_item extends Model_Manip 
{
    /* start>>>>> */
    /**
     * sort 
     * @var number 
     */
    public $sort = null;

    /**
     * item 
     * @var string 
     */
    public $item = null;

    /**
     * required 
     * @var number 
     */
    public $required = null;

    /**
     * visible 
     * @var number 
     */
    public $visible = null;

    /**
     * type 
     * @var number 
     */
    public $type = null;

    /**
     * answers 
     * @var string 
     */
    public $answers = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_item';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'sort'=> array(
            'column'=>    'sort',
            'type'=>      'number',
            'default'=>   '1',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'item'=> array(
            'column'=>    'item',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'required'=> array(
            'column'=>    'required',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'visible'=> array(
            'column'=>    'visible',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'type'=> array(
            'column'=>    'type',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
        'answers'=> array(
            'column'=>    'answers',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripJavaScript'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'sort,item,required,visible,type,answers';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':sort,:item,:required,:visible,:type,:answers';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'sort=:sort, item=:item, required=:required, visible=:visible, type=:type, answers=:answers';
    /* <<<<<end */

    /**
     * 初期値データへの加工処理
     *
     * @access protected
     * @retrun void
     */
    protected function initEffect()
    {
        /* 外部からの変更がない場合 */
        if (empty($this->answers)){
            $this->answers = explode("\r\n", $this->new_values['answers']);
        }
    }

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            return ;
        }

        if ($this->action_flag == RKT_Model::QUERY_INSERT){
            $max = RKT_DB::getRow($this->tbl_name, null, 'max(sort) as mx');
            $this->sort = empty($max['mx'])? 1:$max['mx']+1;
        }

        if (is_array($this->answers)){
            $this->answers = implode("\r\n", $this->answers);
        }
    }
} // class act_item
?>
