<?php
/* SVN FILE: $Id: act_cancel.php 377 2008-05-15 02:35:21Z bb_yujiro $ */
/**
 * act_cancelテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_cancelテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 377 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:35:21 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_cancel extends Model_Manip 
{
    /* start>>>>> */
    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * reason 
     * @var string 
     */
    public $reason = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_cancel';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'reason'=> array(
            'column'=>    'reason',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'8000'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_CHATCH,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'ref_account,modified,reason';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':ref_account,:modified,:reason';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'ref_account=:ref_account, modified=:modified, reason=:reason';
    /* <<<<<end */

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        $this->_triggerAccount();
        $this->_triggerBlog();
        $this->_triggerCalendar();
        $this->_triggerCommunity();
        $this->_triggerFavorite();
        $this->_triggerFriends();
    }

    /**
     * アカウント関連トリガー
     *
     * @access private
     */
    private function _triggerAccount()
    {
        /* ログイン停止 */
        $sql = 'UPDATE '.DB_PREFIX.'act_account '.
               'SET avail = '.STATUS_DISABLE.', '.
                   "hashed_email = '".md5($this->ref_account)."' ".
                'WHERE id = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* アルバム削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'act_album '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 添付ファイル削除 （実体は残す）*/
        $sql = 'DELETE FROM '.DB_PREFIX.'act_attach '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 自動ログイン削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'act_autologin '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* ガジェット削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'act_gadget '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 携帯メール削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'act_mobile '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * ブログ関連トリガー
     *
     * @access private
     */
    private function _triggerBlog()
    {
        /* ブログRSS停止 */
        $sql = 'UPDATE '.DB_PREFIX.'blg_blog '.
               "SET rss = '' ".
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * カレンダー関連トリガー
     *
     * @access private
     */
    private function _triggerCalendar()
    {
        /* スケジュールコメント削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'cal_comment '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* スケジュール削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'cal_schedule '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * コミュニティトリガー
     *
     * @access private
     */
    private function _triggerCommunity()
    {
        $condition = array(
            'ref_account'=> $this->ref_account
        );
        $list = RKT_DB::getList('com_community', $condition);

        /* コミュニティメンバー削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'com_names '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);        
        foreach ($list as $row){
            if (empty($row['member_num'])){
                $this->_deleteCommunity($row['id']);
            } else {
                $condition = array(
                    'ref_community'=> $row['id']
                );
                $name = RKT_DB::getList('com_names', $condition);
                if (!empty($row['member_num'])){
                    $sql = 'UPDATE '.DB_PREFIX.'com_community '.
                           'SET ref_account = '.$name['id'].','.
                               'member_num  = '.($row['member_num'] -1).' '.
                           'WHERE id = '.$row['id'];
                    $this->objdb->exec($sql);
                } else {
                    $this->_deleteCommunity($row['id']);
                }
            }
        } // foreach ($list as $row)
    }

    /**
     * お気に入り関連トリガー
     *
     * @access private
     */
    private function _triggerFavorite()
    {
        /* お気に入り削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'fav_favorite '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* お気に入りタグ削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'fav_tag '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * 友達関連トリガー
     *
     * @access private
     */
    private function _triggerFriends()
    {
        /* 友達コメント削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'fri_comment '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql = 'DELETE FROM '.DB_PREFIX.'fri_comment '.
               'WHERE ref_friend = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 友達削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'fri_friends '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);

        $sql = 'DELETE FROM '.DB_PREFIX.'fri_friends '.
               'WHERE ref_friend = '.$this->ref_account;
        $this->objdb->exec($sql);

        /* 友達招待中削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'fri_invite '.
               'WHERE ref_account = '.$this->ref_account.
                ' AND ref_friend = 0';
        $this->objdb->exec($sql);

        /* メッセージ削除 */
        $sql = 'DELETE FROM '.DB_PREFIX.'fri_message '.
               'WHERE ref_account = '.$this->ref_account;
        $this->objdb->exec($sql);
    }

    /**
     * お気に入り関連トリガー
     *
     * @access private
     */
    private function _deleteCommunity($id)
    {
        include_once MODEL_DIR.'manips'.DS.'com_community.php';

        $objcom = new com_community();

        $objcom->setCurId($id);
        $objcom->setInitValue();
        $objcom->setDelete();
        $objcom->manip();
    }
} // class act_cancel
?>
