<?php
/* SVN FILE: $Id: act_attach.php 407 2008-05-17 03:53:26Z bb_yujiro $ */
/**
 * act_attachテーブルクラス
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 407 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-17 12:53:26 +0900 (土, 17 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * act_attachテーブルクラス
 *
 * @category        Hitsuji : Model_Manip 
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 407 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-17 12:53:26 +0900 (土, 17 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class act_attach extends Model_Manip 
{
    /**
     * 添付アイコン大
     * @const string
     */
    const LARGE_ICON = 'resource/img/common/attach.gif';

    /**
     * アイコンサイズ大
     * @const integer
     */
    const LARGE_SIZE = 48;

    /**
     * 添付アイコン小
     * @const string
     */
    const SMALL_ICON = 'resource/img/icons/attach.gif';
    /**
     * アイコンサイズ小
     * @const integer
     */
    const SMALL_SIZE = 16;

    /* start>>>>> */
    /**
     * modified 
     * @var date 
     */
    public $modified = null;

    /**
     * ref_account 
     * @var number 
     */
    public $ref_account = null;

    /**
     * ref_album 
     * @var number 
     */
    public $ref_album = null;

    /**
     * title 
     * @var string 
     */
    public $title = null;

    /**
     * mime_type 
     * @var string 
     */
    public $mime_type = null;

    /**
     * origin 
     * @var string 
     */
    public $origin = null;

    /**
     * filename 
     * @var string 
     */
    public $filename = null;

    /**
     * width 
     * @var number 
     */
    public $width = null;

    /**
     * height 
     * @var number 
     */
    public $height = null;

    /**
     * thumbnail 
     * @var string 
     */
    public $thumbnail = null;

    /**
     * t_width 
     * @var number 
     */
    public $t_width = null;

    /**
     * t_height 
     * @var number 
     */
    public $t_height = null;

    /**
     * v_small 
     * @var string 
     */
    public $v_small = null;

    /**
     * v_width 
     * @var number 
     */
    public $v_width = null;

    /**
     * v_height 
     * @var number 
     */
    public $v_height = null;

    /**
     * テーブル名
     * @var string
     */
    protected $tbl_name = 'act_attach';

    /**
     * プライマリキー
     * @var string
     */
    protected $primary_key = 'id';

    /**
     * 項目定義
     * @var array
     */
    protected $column = array(
        'modified'=> array(
            'column'=>    'modified',
            'type'=>      'date',
            'default'=>   'CURRENT_TIMESTAMP',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('format'=>'%Y-%n-%d %H:%i:%s'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_account'=> array(
            'column'=>    'ref_account',
            'type'=>      'number',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_account',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'ref_album'=> array(
            'column'=>    'ref_album',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> 'act_album',
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'title'=> array(
            'column'=>    'title',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'mime_type'=> array(
            'column'=>    'mime_type',
            'type'=>      'string',
            'default'=>   'empty',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'64'),
            'required'=>  TRUE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'origin'=> array(
            'column'=>    'origin',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'filename'=> array(
            'column'=>    'filename',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'width'=> array(
            'column'=>    'width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'height'=> array(
            'column'=>    'height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'thumbnail'=> array(
            'column'=>    'thumbnail',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        't_width'=> array(
            'column'=>    't_width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        't_height'=> array(
            'column'=>    't_height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_small'=> array(
            'column'=>    'v_small',
            'type'=>      'string',
            'default'=>   '',
            'pdo_type'=>  PDO::PARAM_STR,
            'option'=>    array('max_length'=>'255'),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_width'=> array(
            'column'=>    'v_width',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
        'v_height'=> array(
            'column'=>    'v_height',
            'type'=>      'number',
            'default'=>   '0',
            'pdo_type'=>  PDO::PARAM_INT,
            'option'=>    array(),
            'required'=>  FALSE,
            'effect'=>    array('RKT_Request', 'multiStripTags'),
            'reference'=> FALSE,
            'input'=>     RKT_Model::INPUT_DIRECT,
        ),
    );

    /**
     * リスト用参照テーブル
     * @var array
     */
    protected $reference = array(
    );

    /**
     * カンマ区切り全項目
     * @var string
     */
    protected $cs_columns = 'modified,ref_account,ref_album,title,mime_type,origin,filename,width,height,thumbnail,t_width,t_height,v_small,v_width,v_height';

    /**
     * baindフォーマットの全項目
     * @var string
     */
    protected $bind_columns = ':modified,:ref_account,:ref_album,:title,:mime_type,:origin,:filename,:width,:height,:thumbnail,:t_width,:t_height,:v_small,:v_width,:v_height';

    /**
     * Update用baindフォーマットの全項目
     * @var string
     */
    protected $set_columns = 'modified=:modified, ref_account=:ref_account, ref_album=:ref_album, title=:title, mime_type=:mime_type, origin=:origin, filename=:filename, width=:width, height=:height, thumbnail=:thumbnail, t_width=:t_width, t_height=:t_height, v_small=:v_small, v_width=:v_width, v_height=:v_height';
    /* <<<<<end */

    /**
     * ファイル名 
     * @var string 
     */
    public $name = null;

    /**
     * 処理前トリガー
     *
     * @access public
     */
    protected function triggerBefore()
    {
    }

    /**
     * 処理後トリガー
     *
     * @access public
     */
    protected function triggerAfter()
    {
        if ($this->action_flag == RKT_Model::QUERY_DELETE){
            include_once LIB_DIR.'rkt_blob.php';
            $objblb = RKT_Blob::getInstance();

            $objblb->unlink($this->old_values['origin']);
            $objblb->unlink($this->old_values['filename']);
            $objblb->unlink($this->old_values['thumbnail']);
            $objblb->unlink($this->old_values['v_small']);
        } // if ($this->action_flag == RKT_Model::QUERY_DELETE)

        if (!empty($this->old_values['ref_album'])){
            if ($this->ref_album != $this->old_values['ref_album']){
                $this->_updatePosts($this->old_values['ref_album']);
            }
        } // if (!empty($this->old_values['ref_album']))

        $this->_updatePosts($this->ref_album);
    }

    /**
     * アップロードされた情報をメンバ変数へセットする
     *
     * @access public
     * @param string $key
     * @return boolean 成功時真
     */
    public function catchFile($key)
    {
        if (!isSet($_FILES[$key])) {
            return false;
        }
        if ($_FILES[$key]['error'] != UPLOAD_ERR_OK) {
            return false;
        }
        include LIB_DIR.'rkt_blob.php';

        $this->filename  = $_FILES[$key]['tmp_name'];
        $this->title     = $_FILES[$key]['name'];
        $this->name      = $_FILES[$key]['name'];
        $this->mime_type = $_FILES[$key]['type'];

        $this->_saveOrigin();

        /* ファイルの種類が画像か判定 */
        $pos = strpos($_FILES[$key]['type'], 'image');
        if (false !== $pos){
            $this->_saveResize();
        } else {
            $this->_setAttachIcon();
        }


        return true;
    }

    /**
     * アップされたファイルを保存する
     *
     * @access public
     * @return void
     */
    private function _saveOrigin()
    {
        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        $objblb = RKT_Blob::getInstance();
        
        $objblb->setUID($this->ref_account);
        $objblb->readfile($this->filename);

        $extension  = $objblb->getExtension($this->name);
        $this->name = $name.'.'.$extension;

        $extension = $objblb->getExtension($this->name);
        $filename  = ARCHIVES_MEMBER_PATH.$this->ref_account.'/origin/'.$this->name;
        $objblb->save($filename);

        $this->origin = $filename;
    }

    /**
     * アップされた画像ファイルをリサイズする
     *
     * @access public
     * @return void
     */
    private function _saveResize()
    {
        include_once LIB_DIR.'rkt_image.php';
        $objblb = RKT_Blob::getInstance();
        $objimg = RKT_Image::getInstance();
        
        $objimg->readImage($this->filename);
        $objblb->setUID($this->ref_account);

        /* 大きいサイズの画像 */
        $objimg->resize(PHOTO_MAX_SIZE, PHOTO_MAX_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/large/'.$this->name;
        $objblb->save($filename);
        $this->filename = $filename;
        $this->width    = $infos['width'];
        $this->height   = $infos['height'];

        /* 小さいサイズの画像 */
        $objimg->resize(PHOTO_SMALL_SIZE, PHOTO_SMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/small/'.$this->name;
        $objblb->save($filename);
        $this->thumbnail = $filename;
        $this->t_width   = $infos['width'];
        $this->t_height  = $infos['height'];

        /* さらに小さいサイズの画像 */
        $objimg->resize(PHOTO_VSMALL_SIZE, PHOTO_VSMALL_SIZE);
        $infos  = $objimg->getInfo();
        $buffer = $objimg->getBinary();
        $objblb->setBuffer($buffer);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/vsmall/'.$this->name;
        $objblb->save($filename);
        $this->v_small  = $filename;
        $this->v_width  = $infos['width'];
        $this->v_height = $infos['height'];
    }

    /**
     * アップされた画像ファイルをリサイズする
     *
     * @access public
     * @return void
     */
    private function _setAttachIcon()
    {
        $objblb = RKT_Blob::getInstance();
        $objblb->setUID($this->ref_account);

        /* 大きいサイズのアイコン */
        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/large/'.$this->name;
        $objblb->readfile(DOCUMENT_DIR.self::LARGE_ICON);
        $objblb->save($filename);
        $this->filename = $filename;
        $this->width    = self::LARGE_SIZE;
        $this->height   = self::LARGE_SIZE;

        /* 大きいサイズのアイコン */
        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/small/'.$this->name;
        $objblb->save($filename);
        $this->thumbnail = $filename;
        $this->t_width   = self::LARGE_SIZE;
        $this->t_height  = self::LARGE_SIZE;

        /* さらに小さいサイズの画像 */
        $temp = md5($this->ref_account.time());
        $name = substr($temp, rand(0,25), 6);

        $filename = ARCHIVES_MEMBER_PATH.$this->ref_account.'/vsmall/'.$name.'gif';
        $objblb->readfile(DOCUMENT_DIR.self::SMALL_ICON);
        $objblb->save($filename);
        $this->v_small  = $filename;
        $this->v_width  = self::SMALL_SIZE;
        $this->v_height = self::SMALL_SIZE;
    }

    /**
     * 処理後トリガー
     *
     * @access private
     * @param integer $ref_album
     * @return void
     */
    private function _updatePosts($ref_album)
    {
        if (empty($ref_album)){
            return ;
        }
        include_once MODEL_DIR.'manips'.DS.'act_album.php';
        $objalb = new act_album();

        $objalb->setCurId($ref_album);
        $objalb->setInitValue();

        $condition = array(
            'ref_account'=> $this->ref_account,
            'ref_album'=>   $ref_album
        );
        $row = RKT_DB::getRow($this->tbl_name, $condition, 'count(*) as ct');

        $objalb->setValue('posts',  $row['ct']);
        $objalb->manip();
    }

} // class act_attach
?>
