<?php
/* SVN FILE: $Id: config.php 444 2008-05-20 08:53:56Z bb_yujiro $ */
/**
 * 実行処理
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 444 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:56 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 444 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-20 17:53:56 +0900 (火, 20 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends RKT_Controller
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $result = false;
        if (!empty($_POST['manip'])){
            if ($this->objrqt->getValidate()){
                $result = true;
                $this->_replaceDefine();

                $this->_replaceCSS(RESOURCE_DIR.'css'.DS.'admin.css');
                $this->_replaceCSS(RESOURCE_DIR.'css'.DS.'common.css');
                $this->_replaceCSS(RESOURCE_DIR.'css'.DS.'community.css');
                $this->_replaceCSS(RESOURCE_DIR.'css'.DS.'member.css');
                $this->_replaceCSS(RESOURCE_DIR.'css'.DS.'private.css');
            } else {
                $this->assign('alert', $this->objrqt->getAlerts());
            }
        } // if (!empty($_POST['manip']))

        $this->_setPathInfoKey();
        $this->_setDbDriver();
        $this->assign('complete', $result);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'administrator'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
            ),
            'sns_name'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'copyright'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'system_invite'=> array(
                'type'=>     'number',
                'option'=>   array(),
                'required'=> true,
            ),
            'base_url'=> array(
                'type'=>     'uri',
                'option'=>   array(),
                'required'=> true,
            ),
            'ssl_url'=> array(
                'type'=>     'uri',
                'option'=>   array(),
                'required'=> true,
            ),
            'path_info_key'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'db_driver'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'db_name'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'db_host'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'db_user'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'db_password'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'use_set_names'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'pass_seed'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'pass_phrase'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'amazon_associateid'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'gnavi_access_key'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'imagemagick_path'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'image_driver'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'used_smtp'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'smtp_host'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'smtp_port'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'smtp_auth'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'smtp_account'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'smtp_password'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> true,
            ),
            'attach_driver'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'attach_mail'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'action_mail'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'pop3_host'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'pop3_account'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'pop3_password'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
            'mail_box_dir'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * パスインフォキーの設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function _setPathInfoKey()
    {
        $PathInfo = array(
            'QUERY_STRING'=>   _('Default').'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(&nbsp;exec.php?/private/home/&nbsp;)',
            'PATH_INFO'=>      'PATH_INFO'.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(&nbsp;exec/private/home/&nbsp;)',
            'ORIG_PATH_INFO'=> 'ORIG_PATH_INFO'.'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(&nbsp;exec/private/home/&nbsp;)',
        );
        $this->assign('PathInfo', $PathInfo);
    }

    /**
     * DBドライバの設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function _setDbDriver()
    {
        $db_drivers = array(
            'mysql'=>  'MySQL',
            'pgsql'=>  'PostgreSQL',
            'sqlite'=> 'SQLite',
        );
        $this->assign('db_drivers', $db_drivers);
    }

    /**
     * 定義値の置換
     *
     * @access private
     * @return boolean  データ操作結果
     */
    public function _replaceDefine()
    {
        /* ファイルの中身を取得 */
        $buffer = file_get_contents(BASE_DIR.'config.php');

        $this->values['invite'] = empty($this->values['invite'])?'FALSE':'TRUE';
        $this->values['used_smtp'] = empty($this->values['used_smtp'])?'FALSE':'TRUE';
        $this->values['smtp_auth'] = empty($this->values['smtp_auth'])?'FALSE':'TRUE';

        /* MySQL以外はSet Nnamesを発行しない */
        if ($this->values['db_driver'] != 'mysql'){
            $this->values['use_set_names'] = 0;
        }

        foreach ($this->conditions as $key=>$_tmp){
            $value = $this->values[$key];

            $key = strtoupper($key);
            if ('INVITE' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                "define('".$key."', ".$value.");",
                                $buffer,
                                1);
            } elseif ('USED_SMTP' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                "define('".$key."', ".$value.");",
                                $buffer,
                                1);
            } elseif ('SMTP_AUTH' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*(TRUE|FALSE)\);/",
                                "define('".$key."', ".$value.");",
                                $buffer,
                                1);
            } elseif ('COPYRIGHT' === $key){
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*\".*\"\);/",
                                "define('".$key."', \"".$value."\");",
                                $buffer,
                                1);
            } else {
                $buffer = preg_replace(
                                "/define\s*\('".$key."',\s*'.*'\);/",
                                "define('".$key."', '".$value."');",
                                $buffer,
                                1);
            }
        } // foreach ($this->values as $key=>$value)
        
        /* データベースDSNの設定 */
        $sns_dsn =  "'.SYSTEM_DB_FILE";
        $blob_dsn = 'BLOB_DB_DSN';
        if ($this->values['db_driver'] != 'sqlite'){
            $sns_dsn  = 'host='.$this->values['db_host'].';';
            $sns_dsn .= 'dbname='.$this->values['db_name']."'";
            $blob_dsn = 'DB_DSN';
        }
        $buffer = preg_replace(
                        "/define\s*\('DB_DSN',\s*DB_DRIVER\.('[_:=;\w]+\'|':'\.SYSTEM_DB_FILE)\);/",
                        "define('DB_DSN', DB_DRIVER.':".$sns_dsn.');',
                        $buffer,
                        1);
        $buffer = preg_replace(
                        "/define\s*\('BLOB_PARAM',\s*(DB_DSN|BLOB_DB_DSN)\);/",
                        "define('BLOB_PARAM', ".$blob_dsn.");",
                        $buffer,
                        1);

        /* PathInfoの設定 */
        $action_style  = '';
        $uri_separator = '?';
        $method        = 'get';
        if (preg_match('/QUERY_STRING/i',$this->values['path_info_key'])){
            $action_style  = '.php?';
            $uri_separator = '&';
            $method        = 'post';
        }
        $buffer = preg_replace(
                        "/define\s*\('ACTION_STYLE',\s*'.*'\);/",
                        "define('ACTION_STYLE', '".$action_style."');",
                        $buffer,
                        1);
        $buffer = preg_replace(
                        "/define\s*\('US',\s*'.*'\);/",
                        "define('US', '".$uri_separator."');",
                        $buffer,
                        1);
        $buffer = preg_replace(
                        "/define\s*\('METHOD',\s*'.*'\);/",
                        "define('METHOD', '".$method."');",
                        $buffer,
                        1);

        $handle = fopen(BASE_DIR.'config.php', 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $buffer);
        fclose($handle);

        return true;
    }

    /**
     * スタイルシートの置換
     *
     * @access private
     * @param string $filename
     * @return boolean  データ操作結果
     */
    public function _replaceCSS($filename)
    {
        /* ファイルの中身を取得 */
        $handle = fopen($filename, 'r');
        if (!is_resource($handle)) {
            return false;
        }
        $buffer = fread($handle, filesize($filename));
        fclose($handle);
        
        $base_url = $this->values['base_url'];

        $buffer = str_replace ('http://sns.example.com/', $base_url, $buffer);
        $buffer = str_replace ('http://localhost/hitsuji/', $base_url, $buffer);

        $handle = fopen($filename, 'w');
        if (!is_resource($handle)) {
            return false;
        }
        $result = fwrite($handle, $buffer);
        fclose($handle);

        return true;
    }
} // Controller
?>