<?php
/* SVN FILE: $Id: view.php 495 2008-05-24 11:46:17Z bb_yujiro $ */
/**
 * Model_View Controller
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 495 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:46:17 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * Controllerクラス
 *
 * @category        Hitsuji : Controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 495 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-24 20:46:17 +0900 (土, 24 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller 
{
    /**
     * 使用モデル名
     * @var array
     */
    public $models = array(
        'manip'=> array(
        ),
        'view'=> array(
            'rev_trackback'
        ),
    );

    /**
     * act_profile モデルオブジェクト
     * @var object 
     */
    public $v_rev_trackback = null;

    /**
     * サービス名
     * @var string
     */
    protected $service = null;

    /**
     * 商品コード
     * @var string
     */
    protected $item_code = null;

    /**
     * 変数の初期化
     *
     * @abstract
     * @access protected
     * @return void
     */
    protected function initValue()
    {
        $this->objvew->setTemplate('sidebar_tpl', 'common/menu/review.tpl');

        $this->v_rev_trackback->setOrder('modified DESC');
        $this->v_rev_trackback->setValue('item_code', $this->item_code);
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return void
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'service'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'item_code'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
                'pic_up'=>   'PathArgs'
            ),
            'keyword'=> array(
                'type'=>     'string',
                'option'=>   array(),
                'required'=> false,
            ),
        );
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        $this->objvew->addJavas('js/rating.js');
        $this->_setCategory();
        $this->_setReview();
    }

    /**
     * レビュー用関連記事の設定
     *
     * @access private
     * @return void
     **/
    private function _setReview()
    {
        $methods = array(
            'amazon'=> '_setAmazon',
            'gnavi'=>  '_setGnavi',
        );
        $method = empty($methods[$this->service])? '_setAmazon':$methods[$this->service];
        call_user_func(array(&$this, $method));
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     **/
    private function _setCategory()
    {
        $list = RKT_DB::getList('rev_category', null, '*', 'sort');

        $categories = array();
        foreach ($list as $row){
            $categories[$row['id']] = $row['label'];
            $this->categories[$row['id']] = $row;
        }
        $this->objvew->assign('rev_categories', $categories);
    }

    /**
     * 評価の取得
     *
     * @access private
     * @param string item_code
     * @return void
     **/
    private function _getRating($item_code)
    {
        $condition = array(
            'item_code'=>   $item_code,
        );
        $review = RKT_DB::getRow('rev_review', $condition);

        $condition = array(
            'item_code'=>   $item_code,
            'ref_account'=> $this->account['id'],
        );
        $rating = RKT_DB::getRow('rev_rating', $condition);
        
        return array(
            'posts'=>  empty($review['posts'])?  0:$review['posts'],
            'point'=> empty($rating['point'])? 0:$rating['point'],
        );
    }

    /**
     * Amazon情報
     *
     * @access public
     * @return array
     */
    private function _setAmazon()
    {
        include LIB_DIR.'PEAR/Services/AmazonECS4.php';
        $amazon = new Services_AmazonECS4(AMAZON_TOKEN, AMAZON_ASSOCIATEID);
        $options = array(
            'ResponseGroup'=> 'Medium'
        );
        $result = $amazon->ItemLookup($this->item_code, $options);
        if (PEAR::isError($result)) {
            return ;
        }
        if (empty($result['Item'][0])){
            return ;
        }
        $row = $result['Item'][0];

        $allowable_tags = '<br><b><a><ul><li>';
        $comment  = empty($row['ItemAttributes']['Author'][0])? '':$row['ItemAttributes']['Author'][0].'<br>';
        $comment .= empty($row['ItemAttributes']['Artist'])? '':$row['ItemAttributes']['Artist'].'<br>';
        $comment .= empty($row['ItemAttributes']['Manufacturer'])? '':$row['ItemAttributes']['Manufacturer'].'<br>';
        $comment .= empty($row['OfferSummary']['LowestNewPrice']['FormattedPrice'])? '':$row['OfferSummary']['LowestNewPrice']['FormattedPrice'].'<br>';
        $comment .= empty($row['EditorialReviews']['EditorialReview'][0]['Source'])? '':'<br />'.$row['EditorialReviews']['EditorialReview'][0]['Source'].'<br />';
        $comment .= empty($row['EditorialReviews']['EditorialReview'][0]['Content'])? '':strip_tags($row['EditorialReviews']['EditorialReview'][0]['Content'], $allowable_tags).'<br />';

        $rating = $this->_getRating($row['ASIN']);

        $item = array(
            'item_code'=> $row['ASIN'],
            'view_url'=>  $row['DetailPageURL'],
            'small_img'=> empty($row['SmallImage']['URL'])? BASE_URL.NOPHOTO_SMALL:$row['SmallImage']['URL'],
            'large_img'=> empty($row['MediumImage']['URL'])? BASE_URL.NOPHOTO_LARGE:$row['MediumImage']['URL'],
            'title'=>     $row['ItemAttributes']['Title'],
            'comment'=>   $comment,
            'posts'=>      $rating['posts'],
            'point'=>     $rating['point'],
        );

        $this->objvew->assign('item', $item);
        $this->objvew->assign('service',   'amazon');
        $this->objvew->assign('atService', 'Amazon');

        $this->objvew->assign('class_name',  'horizontal');
        $this->objvew->assign('left_width',  166);
        $this->objvew->assign('right_width', 370);
    }

    /**
     * ぐるなび情報
     *
     * @access public
     * @return array
     */
    private function _setGnavi()
    {
        include LIB_DIR.'PEAR/Services/Gnavi.php';
        $gnavi = new Services_Gnavi(GNAVI_ACCESS_KEY);
        $options = array(
            'id'=> $this->item_code
        );
        $gnavi->searchRestaurant($options);
        $result = $gnavi->getResult();
        if (PEAR::isError($result)) {
            return null;
        }
        if (empty($result['rest'])){
            return null;
        }

        $rating = $this->_getRating($row['id']);
        $item = array(
            'item_code'=> $result['id'],
            'view_url'=>  $result['url'],
            'small_img'=> BASE_URL.'review'.ACTION_STYLE.'/gnavi/'.$result['id'].'.jpg',
            'large_img'=> BASE_URL.'review'.ACTION_STYLE.'/gnavi/'.$result['id'].'.jpg',
            'title'=>     $result['name'],
            'comment'=>   $result['pr']['pr_long'],
            'posts'=>      $rating['posts'],
            'point'=>     $rating['point'],
        );

        $this->objvew->assign('item', $item);
        $this->objvew->assign('service',   'gnavi');
        $this->objvew->assign('atService', 'ぐるなび');

        $this->objvew->assign('class_name',  '');
        $this->objvew->assign('left_width',  520);
        $this->objvew->assign('right_width', 510);
    }
} // class Controller
?>
