<?php
/* SVN FILE: $Id: reissue.php 385 2008-05-15 02:43:17Z bb_yujiro $ */
/**
 * ログイン
 *
 * PHP versions 5
 *
 *      Hitsuji : Social Network Service <http://rakuto.net/rktSNS/>
 *      Copyright (c) 2007 Yujiro Takahashi
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @filesource
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */

/**
 * WebApplicationクラス
 *
 * @category        Hitsuji : controller
 * @package         Hitsuji
 * @copyright       Copyright (c) 2007 Yujiro Takahashi
 * @link            http://rakuto.net/rktSNS/
 * @author          Yujiro Takahashi <yujiro@rakuto.net>
 * @version         $Revision: 385 $
 * @modifiedby      $LastChangedBy: bb_yujiro $
 * @lastmodified    $Date: 2008-05-15 11:43:17 +0900 (木, 15 5 2008) $
 * @license         http://opensource.org/licenses/mit-license.php The MIT License
 */
class Controller extends Public_Controller
{
    /**
     * メールアドレス
     * @var string
     */
    protected $email = null;

    /**
     * 確認用メールアドレス
     * @var string
     */
    protected $verification = null;

    /**
     * アカウント
     * @var integer
     */
    private $_id = null;

    /**
     * パスワード
     * @var string
     */
    private $_password = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    protected function action()
    {
        if ($this->checked_nonce){
            if ($this->_findEmail()){
                if ($this->_updatePassword()){
                    $this->_sendPassowrd();
                    $this->objvew->assign('sent', true);
                }
            }
        }
    }

    /**
     * 入力条件の設定
     *
     * @access protected
     * @return string   絞込み句
     **/
    protected function setCondition()
    {
        $this->conditions = array (
            'email'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
            'verification'=> array(
                'type'=>     'email',
                'option'=>   array(),
                'required'=> true,
                'input'=>    RKT_Model::INPUT_CHATCH,
            ),
        );
    }

    /**
     * メールアドレスのチェック
     *
     * @access private
     * @return void
     **/
    private function _findEmail()
    {
        if ($this->email !== $this->verification){
            $this->objvew->assign('unmatched', true);
            return false;
        }

        $hashed_email = RKT_Crypt::getHashed($this->email);
        $condition = array(
            'hashed_email'=> $hashed_email
        );
        $account = RKT_DB::getRow('act_account', $condition);        
        if (empty($account['id'])){
            $account = RKT_DB::getRow('act_mobile', $condition);
            if (empty($account['id'])){
                $this->objvew->assign('nosuch', true);
                return false;
            }
        } // if (empty($account['id']))
        $this->_id = $account['id'];

        return true;
    }

    /**
     * メールアドレスのチェック
     *
     * @access private
     * @return void
     **/
    private function _sendPassowrd()
    {
        include_once LIB_DIR.'rkt_message.php';
        $objsnd = RKT_Message::getInstance('reissue');

        $condition = array(
            'ref_account'=> $this->_id
        );
        $profile = RKT_DB::getRow('act_profile', $condition);

        $objsnd->Assign('user_name', $profile['nickname']);
        $objsnd->Assign('password',  $this->_password);
        $objsnd->send($this->email);
    }

    /**
     * パスワードの更新
     *
     * @access private
     * @return integer  データ操作結果
     */
    private function _updatePassword()
    {
        $seed = strtolower(md5(time()));
        $this->_password = substr($seed, 9, 6);

        include LIB_DIR.'rktModel'.DS.'Manip.php';
        include MODEL_DIR.'manips'.DS.'act_account.php';

        $objact = new act_account();
        $objact->setCurID($this->_id);
        $objact->setInitValue();
        $objact->setValue('hashed_password', $this->_password);
        $objact->setValue('email',           null);
        return $objact->manip();
    }

} // class Controller
?>
